/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.base.messages.InternalPlcSubscriptionRequest;
import org.apache.plc4x.java.base.messages.InternalPlcSubscriptionResponse;

public class DefaultPlcSubscriptionResponse
implements InternalPlcSubscriptionResponse {
    private final InternalPlcSubscriptionRequest request;
    private final Map<String, Pair<PlcResponseCode, PlcSubscriptionHandle>> values;

    public DefaultPlcSubscriptionResponse(InternalPlcSubscriptionRequest request, Map<String, Pair<PlcResponseCode, PlcSubscriptionHandle>> values) {
        this.request = request;
        this.values = values;
    }

    public PlcSubscriptionHandle getSubscriptionHandle(String name) {
        return (PlcSubscriptionHandle)this.values.get(name).getValue();
    }

    public Collection<String> getFieldNames() {
        return this.values.keySet();
    }

    public PlcField getField(String name) {
        throw new NotImplementedException("field access not implemented");
    }

    public PlcResponseCode getResponseCode(String name) {
        return (PlcResponseCode)this.values.get(name).getKey();
    }

    public PlcSubscriptionRequest getRequest() {
        return this.request;
    }

    public Collection<PlcSubscriptionHandle> getSubscriptionHandles() {
        return this.values.values().stream().map(Pair::getValue).collect(Collectors.toList());
    }
}

