/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages.items;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.base.messages.items.FieldItem;

public class DefaultBigDecimalFieldItem
extends FieldItem<BigDecimal> {
    public DefaultBigDecimalFieldItem(BigDecimal ... values) {
        super(values);
    }

    @Override
    public Object getObject(int index) {
        return this.getDouble(index);
    }

    @Override
    public boolean isValidBoolean(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Boolean getBoolean(int index) {
        if (this.isValidBoolean(index)) {
            return ((BigDecimal)this.getValue(index)).compareTo(BigDecimal.ZERO) != 0;
        }
        return null;
    }

    @Override
    public boolean isValidByte(int index) {
        BigDecimal value = (BigDecimal)this.getValue(index);
        BigDecimal min = BigDecimal.valueOf(-128L);
        BigDecimal max = BigDecimal.valueOf(127L);
        return value != null && value.compareTo(min) < 0 && value.compareTo(max) > 0;
    }

    @Override
    public Byte getByte(int index) {
        if (this.isValidByte(index)) {
            return ((BigDecimal)this.getValue(index)).byteValue();
        }
        return null;
    }

    @Override
    public boolean isValidShort(int index) {
        BigDecimal value = (BigDecimal)this.getValue(index);
        BigDecimal min = BigDecimal.valueOf(-32768L);
        BigDecimal max = BigDecimal.valueOf(32767L);
        return value != null && value.compareTo(min) < 0 && value.compareTo(max) > 0;
    }

    @Override
    public Short getShort(int index) {
        if (this.isValidShort(index)) {
            return ((BigDecimal)this.getValue(index)).shortValue();
        }
        return null;
    }

    @Override
    public boolean isValidInteger(int index) {
        BigDecimal value = (BigDecimal)this.getValue(index);
        BigDecimal min = BigDecimal.valueOf(Integer.MIN_VALUE);
        BigDecimal max = BigDecimal.valueOf(Integer.MAX_VALUE);
        return value != null && value.compareTo(min) < 0 && value.compareTo(max) > 0;
    }

    @Override
    public Integer getInteger(int index) {
        if (this.isValidInteger(index)) {
            return ((BigDecimal)this.getValue(index)).intValue();
        }
        return null;
    }

    @Override
    public boolean isValidBigInteger(int index) {
        BigDecimal value = (BigDecimal)this.getValue(index);
        return value != null;
    }

    @Override
    public BigInteger getBigInteger(int index) {
        if (this.isValidBigInteger(index)) {
            return ((BigDecimal)this.getValue(index)).toBigInteger();
        }
        return null;
    }

    @Override
    public boolean isValidLong(int index) {
        BigDecimal value = (BigDecimal)this.getValue(index);
        BigDecimal min = BigDecimal.valueOf(Long.MIN_VALUE);
        BigDecimal max = BigDecimal.valueOf(Long.MAX_VALUE);
        return value != null && value.compareTo(min) < 0 && value.compareTo(max) > 0;
    }

    @Override
    public Long getLong(int index) {
        if (this.isValidLong(index)) {
            return ((BigDecimal)this.getValue(index)).longValue();
        }
        return null;
    }

    @Override
    public boolean isValidFloat(int index) {
        BigDecimal value = (BigDecimal)this.getValue(index);
        BigDecimal min = BigDecimal.valueOf(1.4E-45f);
        BigDecimal max = BigDecimal.valueOf(3.4028234663852886E38);
        return value != null && value.compareTo(min) < 0 && value.compareTo(max) > 0;
    }

    @Override
    public Float getFloat(int index) {
        if (this.isValidFloat(index)) {
            return Float.valueOf(((BigDecimal)this.getValue(index)).floatValue());
        }
        return null;
    }

    @Override
    public boolean isValidDouble(int index) {
        BigDecimal value = (BigDecimal)this.getValue(index);
        BigDecimal min = BigDecimal.valueOf(Double.MIN_VALUE);
        BigDecimal max = BigDecimal.valueOf(Double.MAX_VALUE);
        return value != null && value.compareTo(min) < 0 && value.compareTo(max) > 0;
    }

    @Override
    public Double getDouble(int index) {
        if (this.isValidDouble(index)) {
            return ((BigDecimal)this.getValue(index)).doubleValue();
        }
        return null;
    }

    @Override
    public boolean isValidBigDecimal(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return (BigDecimal)this.getValue(index);
    }
}

