/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages.items;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.base.messages.items.FieldItem;

public class DefaultBigIntegerFieldItem
extends FieldItem<BigInteger> {
    public DefaultBigIntegerFieldItem(BigInteger ... values) {
        super(values);
    }

    @Override
    public Object getObject(int index) {
        return this.getLong(index);
    }

    @Override
    public boolean isValidBoolean(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Boolean getBoolean(int index) {
        if (this.isValidBoolean(index)) {
            return ((BigInteger)this.getValue(index)).compareTo(BigInteger.ZERO) == 0;
        }
        return null;
    }

    @Override
    public boolean isValidByte(int index) {
        BigInteger value = (BigInteger)this.getValue(index);
        return value != null && value.compareTo(BigInteger.valueOf(127L)) < 0 && value.compareTo(BigInteger.valueOf(-128L)) > 0;
    }

    @Override
    public Byte getByte(int index) {
        if (this.isValidByte(index)) {
            return ((BigInteger)this.getValue(index)).byteValue();
        }
        return null;
    }

    @Override
    public boolean isValidShort(int index) {
        BigInteger value = (BigInteger)this.getValue(index);
        return value != null && value.compareTo(BigInteger.valueOf(32767L)) < 0 && value.compareTo(BigInteger.valueOf(-32768L)) > 0;
    }

    @Override
    public Short getShort(int index) {
        if (this.isValidShort(index)) {
            return ((BigInteger)this.getValue(index)).shortValue();
        }
        return null;
    }

    @Override
    public boolean isValidInteger(int index) {
        BigInteger value = (BigInteger)this.getValue(index);
        return value != null && value.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) < 0 && value.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) > 0;
    }

    @Override
    public Integer getInteger(int index) {
        if (this.isValidInteger(index)) {
            BigInteger value = (BigInteger)this.getValue(index);
            return value.intValue();
        }
        return null;
    }

    @Override
    public boolean isValidBigInteger(int index) {
        BigInteger value = (BigInteger)this.getValue(index);
        return value != null;
    }

    @Override
    public BigInteger getBigInteger(int index) {
        if (this.isValidBigInteger(index)) {
            return (BigInteger)this.getValue(index);
        }
        return null;
    }

    @Override
    public boolean isValidLong(int index) {
        BigInteger value = (BigInteger)this.getValue(index);
        return value != null && value.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) < 0 && value.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) > 0;
    }

    @Override
    public Long getLong(int index) {
        if (this.isValidLong(index)) {
            BigInteger value = (BigInteger)this.getValue(index);
            return value.longValue();
        }
        return null;
    }

    @Override
    public boolean isValidFloat(int index) {
        BigInteger value = (BigInteger)this.getValue(index);
        if (value == null) {
            return false;
        }
        BigDecimal decimalValue = new BigDecimal(value);
        return decimalValue.compareTo(BigDecimal.valueOf(3.4028234663852886E38)) < 0 && decimalValue.compareTo(BigDecimal.valueOf(1.4E-45f)) > 0;
    }

    @Override
    public Float getFloat(int index) {
        if (this.isValidFloat(index)) {
            return Float.valueOf(((BigInteger)this.getValue(index)).floatValue());
        }
        return null;
    }

    @Override
    public boolean isValidDouble(int index) {
        BigInteger value = (BigInteger)this.getValue(index);
        if (value == null) {
            return false;
        }
        BigDecimal decimalValue = new BigDecimal(value);
        return decimalValue.compareTo(BigDecimal.valueOf(Double.MAX_VALUE)) < 0 && decimalValue.compareTo(BigDecimal.valueOf(Double.MIN_VALUE)) > 0;
    }

    @Override
    public Double getDouble(int index) {
        if (this.isValidDouble(index)) {
            return ((BigInteger)this.getValue(index)).doubleValue();
        }
        return null;
    }

    @Override
    public boolean isValidBigDecimal(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return new BigDecimal((BigInteger)this.getValue(index));
    }
}

