/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages.items;

import java.util.BitSet;
import org.apache.plc4x.java.base.messages.items.FieldItem;

public class DefaultBooleanFieldItem
extends FieldItem<Boolean> {
    public DefaultBooleanFieldItem(Boolean ... values) {
        super(values);
    }

    @Override
    public Object getObject(int index) {
        return this.getBoolean(index);
    }

    @Override
    public boolean isValidBoolean(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Boolean getBoolean(int index) {
        if (this.isValidBoolean(index)) {
            return (Boolean)this.getValue(index);
        }
        return null;
    }

    @Override
    public boolean isValidByte(int index) {
        int byteAddress = index >> 3;
        return this.getValue(byteAddress) != null;
    }

    @Override
    public Byte getByte(int index) {
        BitSet bitSet = new BitSet();
        int i = 0;
        for (Boolean value : (Boolean[])this.getValues()) {
            bitSet.set(i, value);
            ++i;
        }
        byte[] bytes = bitSet.toByteArray();
        if (bytes.length < index) {
            return null;
        }
        return bytes[index];
    }
}

