/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages.items;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.base.messages.items.FieldItem;

public class DefaultDoubleFieldItem
extends FieldItem<Double> {
    public DefaultDoubleFieldItem(Double ... values) {
        super(values);
    }

    @Override
    public Object getObject(int index) {
        return this.getDouble(index);
    }

    @Override
    public boolean isValidBoolean(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Boolean getBoolean(int index) {
        if (this.isValidBoolean(index)) {
            return (Double)this.getValue(index) != 0.0;
        }
        return null;
    }

    @Override
    public boolean isValidByte(int index) {
        Double value = (Double)this.getValue(index);
        return value != null && value <= 127.0 && value >= -128.0;
    }

    @Override
    public Byte getByte(int index) {
        if (this.isValidByte(index)) {
            return ((Double)this.getValue(index)).byteValue();
        }
        return null;
    }

    @Override
    public boolean isValidShort(int index) {
        Double value = (Double)this.getValue(index);
        return value != null && value <= 32767.0 && value >= -32768.0;
    }

    @Override
    public Short getShort(int index) {
        if (this.isValidShort(index)) {
            return ((Double)this.getValue(index)).shortValue();
        }
        return null;
    }

    @Override
    public boolean isValidInteger(int index) {
        Double value = (Double)this.getValue(index);
        return value != null && value <= 2.147483647E9 && value >= -2.147483648E9;
    }

    @Override
    public Integer getInteger(int index) {
        if (this.isValidInteger(index)) {
            return ((Double)this.getValue(index)).intValue();
        }
        return null;
    }

    @Override
    public boolean isValidBigInteger(int index) {
        Double value = (Double)this.getValue(index);
        return value != null;
    }

    @Override
    public BigInteger getBigInteger(int index) {
        if (this.isValidBigInteger(index)) {
            return BigInteger.valueOf(((Double)this.getValue(index)).longValue());
        }
        return null;
    }

    @Override
    public boolean isValidLong(int index) {
        Double value = (Double)this.getValue(index);
        return value != null && value <= 9.223372036854776E18 && value >= -9.223372036854776E18;
    }

    @Override
    public Long getLong(int index) {
        if (this.isValidLong(index)) {
            return ((Double)this.getValue(index)).longValue();
        }
        return null;
    }

    @Override
    public boolean isValidFloat(int index) {
        Double value = (Double)this.getValue(index);
        return value != null && value <= 3.4028234663852886E38 && value >= (double)1.4E-45f;
    }

    @Override
    public Float getFloat(int index) {
        if (this.isValidFloat(index)) {
            return Float.valueOf(((Double)this.getValue(index)).floatValue());
        }
        return null;
    }

    @Override
    public boolean isValidDouble(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Double getDouble(int index) {
        if (this.isValidDouble(index)) {
            return (Double)this.getValue(index);
        }
        return null;
    }

    @Override
    public boolean isValidBigDecimal(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return new BigDecimal((Double)this.getValue(index));
    }
}

