/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages.items;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.base.messages.items.FieldItem;

public class DefaultFloatFieldItem
extends FieldItem<Float> {
    public DefaultFloatFieldItem(Float ... values) {
        super(values);
    }

    @Override
    public Object getObject(int index) {
        return this.getDouble(index);
    }

    @Override
    public boolean isValidBoolean(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Boolean getBoolean(int index) {
        if (this.isValidBoolean(index)) {
            return ((Float)this.getValue(index)).floatValue() != 0.0f;
        }
        return null;
    }

    @Override
    public boolean isValidByte(int index) {
        Float value = (Float)this.getValue(index);
        return value != null && value.floatValue() <= 127.0f && value.floatValue() >= -128.0f;
    }

    @Override
    public Byte getByte(int index) {
        if (this.isValidByte(index)) {
            return ((Float)this.getValue(index)).byteValue();
        }
        return null;
    }

    @Override
    public boolean isValidShort(int index) {
        Float value = (Float)this.getValue(index);
        return value != null && value.floatValue() <= 32767.0f && value.floatValue() >= -32768.0f;
    }

    @Override
    public Short getShort(int index) {
        if (this.isValidShort(index)) {
            return ((Float)this.getValue(index)).shortValue();
        }
        return null;
    }

    @Override
    public boolean isValidInteger(int index) {
        Float value = (Float)this.getValue(index);
        return value != null && value.floatValue() <= 2.1474836E9f && value.floatValue() >= -2.1474836E9f;
    }

    @Override
    public Integer getInteger(int index) {
        if (this.isValidInteger(index)) {
            return ((Float)this.getValue(index)).intValue();
        }
        return null;
    }

    @Override
    public boolean isValidBigInteger(int index) {
        Float value = (Float)this.getValue(index);
        return value != null;
    }

    @Override
    public BigInteger getBigInteger(int index) {
        if (this.isValidBigInteger(index)) {
            return BigInteger.valueOf(((Float)this.getValue(index)).longValue());
        }
        return null;
    }

    @Override
    public boolean isValidLong(int index) {
        Float value = (Float)this.getValue(index);
        return value != null && value.floatValue() <= 9.223372E18f && value.floatValue() >= -9.223372E18f;
    }

    @Override
    public Long getLong(int index) {
        if (this.isValidLong(index)) {
            return ((Float)this.getValue(index)).longValue();
        }
        return null;
    }

    @Override
    public boolean isValidFloat(int index) {
        Float value = (Float)this.getValue(index);
        return value != null && value.floatValue() <= Float.MAX_VALUE && value.floatValue() >= Float.MIN_VALUE;
    }

    @Override
    public Float getFloat(int index) {
        if (this.isValidFloat(index)) {
            return (Float)this.getValue(index);
        }
        return null;
    }

    @Override
    public boolean isValidDouble(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Double getDouble(int index) {
        if (this.isValidDouble(index)) {
            return ((Float)this.getValue(index)).doubleValue();
        }
        return null;
    }

    @Override
    public boolean isValidBigDecimal(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return new BigDecimal(((Float)this.getValue(index)).floatValue());
    }
}

