/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages.items;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.base.messages.items.FieldItem;

public class DefaultIntegerFieldItem
extends FieldItem<Integer> {
    public DefaultIntegerFieldItem(Integer ... values) {
        super(values);
    }

    @Override
    public Object getObject(int index) {
        return this.getLong(index);
    }

    @Override
    public boolean isValidBoolean(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Boolean getBoolean(int index) {
        if (this.isValidBoolean(index)) {
            return (long)((Integer)this.getValue(index)).intValue() != 0L;
        }
        return null;
    }

    @Override
    public boolean isValidByte(int index) {
        Integer value = (Integer)this.getValue(index);
        return value != null && value <= 127 && value >= -128;
    }

    @Override
    public Byte getByte(int index) {
        if (this.isValidByte(index)) {
            return ((Integer)this.getValue(index)).byteValue();
        }
        return null;
    }

    @Override
    public boolean isValidShort(int index) {
        Integer value = (Integer)this.getValue(index);
        return value != null && value <= Short.MAX_VALUE && value >= Short.MIN_VALUE;
    }

    @Override
    public Short getShort(int index) {
        if (this.isValidShort(index)) {
            return ((Integer)this.getValue(index)).shortValue();
        }
        return null;
    }

    @Override
    public boolean isValidInteger(int index) {
        Integer value = (Integer)this.getValue(index);
        return value != null;
    }

    @Override
    public Integer getInteger(int index) {
        if (this.isValidInteger(index)) {
            return (Integer)this.getValue(index);
        }
        return null;
    }

    @Override
    public boolean isValidBigInteger(int index) {
        Integer value = (Integer)this.getValue(index);
        return value != null;
    }

    @Override
    public BigInteger getBigInteger(int index) {
        if (this.isValidBigInteger(index)) {
            return BigInteger.valueOf(((Integer)this.getValue(index)).intValue());
        }
        return null;
    }

    @Override
    public boolean isValidLong(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Long getLong(int index) {
        if (this.isValidFloat(index)) {
            return ((Integer)this.getValue(index)).longValue();
        }
        return null;
    }

    @Override
    public boolean isValidFloat(int index) {
        Integer value = (Integer)this.getValue(index);
        return value != null && (float)value.intValue() <= Float.MAX_VALUE && (float)value.intValue() >= Float.MIN_VALUE;
    }

    @Override
    public Float getFloat(int index) {
        if (this.isValidFloat(index)) {
            return Float.valueOf(((Integer)this.getValue(index)).floatValue());
        }
        return null;
    }

    @Override
    public boolean isValidDouble(int index) {
        Integer value = (Integer)this.getValue(index);
        return value != null && (double)value.intValue() <= Double.MAX_VALUE && (double)value.intValue() >= Double.MIN_VALUE;
    }

    @Override
    public Double getDouble(int index) {
        if (this.isValidDouble(index)) {
            return ((Integer)this.getValue(index)).doubleValue();
        }
        return null;
    }

    @Override
    public boolean isValidBigDecimal(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return new BigDecimal((Integer)this.getValue(index));
    }
}

