/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages.items;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.base.messages.items.FieldItem;

public class DefaultLongFieldItem
extends FieldItem<Long> {
    public DefaultLongFieldItem(Long ... values) {
        super(values);
    }

    @Override
    public Object getObject(int index) {
        return this.getLong(index);
    }

    @Override
    public boolean isValidBoolean(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Boolean getBoolean(int index) {
        if (this.isValidBoolean(index)) {
            return (Long)this.getValue(index) != 0L;
        }
        return null;
    }

    @Override
    public boolean isValidByte(int index) {
        Long value = (Long)this.getValue(index);
        return value != null && value <= 127L && value >= -128L;
    }

    @Override
    public Byte getByte(int index) {
        if (this.isValidByte(index)) {
            return ((Long)this.getValue(index)).byteValue();
        }
        return null;
    }

    @Override
    public boolean isValidShort(int index) {
        Long value = (Long)this.getValue(index);
        return value != null && value <= 32767L && value >= -32768L;
    }

    @Override
    public Short getShort(int index) {
        if (this.isValidShort(index)) {
            return ((Long)this.getValue(index)).shortValue();
        }
        return null;
    }

    @Override
    public boolean isValidInteger(int index) {
        Long value = (Long)this.getValue(index);
        return value != null && value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE;
    }

    @Override
    public Integer getInteger(int index) {
        if (this.isValidInteger(index)) {
            return ((Long)this.getValue(index)).intValue();
        }
        return null;
    }

    @Override
    public boolean isValidBigInteger(int index) {
        Long value = (Long)this.getValue(index);
        return value != null;
    }

    @Override
    public BigInteger getBigInteger(int index) {
        if (this.isValidBigInteger(index)) {
            return BigInteger.valueOf((Long)this.getValue(index));
        }
        return null;
    }

    @Override
    public boolean isValidLong(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Long getLong(int index) {
        if (this.isValidFloat(index)) {
            return (Long)this.getValue(index);
        }
        return null;
    }

    @Override
    public boolean isValidFloat(int index) {
        Long value = (Long)this.getValue(index);
        return value != null && (float)value.longValue() <= Float.MAX_VALUE && (float)value.longValue() >= Float.MIN_VALUE;
    }

    @Override
    public Float getFloat(int index) {
        if (this.isValidFloat(index)) {
            return Float.valueOf(((Long)this.getValue(index)).floatValue());
        }
        return null;
    }

    @Override
    public boolean isValidDouble(int index) {
        Long value = (Long)this.getValue(index);
        return value != null && (double)value.longValue() <= Double.MAX_VALUE && (double)value.longValue() >= Double.MIN_VALUE;
    }

    @Override
    public Double getDouble(int index) {
        if (this.isValidDouble(index)) {
            return ((Long)this.getValue(index)).doubleValue();
        }
        return null;
    }

    @Override
    public boolean isValidBigDecimal(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return new BigDecimal((Long)this.getValue(index));
    }
}

