/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages.items;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.base.messages.items.FieldItem;

public class DefaultShortFieldItem
extends FieldItem<Short> {
    public DefaultShortFieldItem(Short ... values) {
        super(values);
    }

    @Override
    public Object getObject(int index) {
        return this.getLong(index);
    }

    @Override
    public boolean isValidBoolean(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Boolean getBoolean(int index) {
        if (this.isValidBoolean(index)) {
            return (long)((Short)this.getValue(index)).shortValue() != 0L;
        }
        return null;
    }

    @Override
    public boolean isValidByte(int index) {
        Short value = (Short)this.getValue(index);
        return value != null && value <= 127 && value >= -128;
    }

    @Override
    public Byte getByte(int index) {
        if (this.isValidByte(index)) {
            return ((Short)this.getValue(index)).byteValue();
        }
        return null;
    }

    @Override
    public boolean isValidShort(int index) {
        Short value = (Short)this.getValue(index);
        return value != null;
    }

    @Override
    public Short getShort(int index) {
        if (this.isValidShort(index)) {
            return (Short)this.getValue(index);
        }
        return null;
    }

    @Override
    public boolean isValidInteger(int index) {
        Short value = (Short)this.getValue(index);
        return value != null;
    }

    @Override
    public Integer getInteger(int index) {
        if (this.isValidInteger(index)) {
            return ((Short)this.getValue(index)).intValue();
        }
        return null;
    }

    @Override
    public boolean isValidBigInteger(int index) {
        Short value = (Short)this.getValue(index);
        return value != null;
    }

    @Override
    public BigInteger getBigInteger(int index) {
        if (this.isValidBigInteger(index)) {
            return BigInteger.valueOf(((Short)this.getValue(index)).shortValue());
        }
        return null;
    }

    @Override
    public boolean isValidLong(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Long getLong(int index) {
        if (this.isValidFloat(index)) {
            return ((Short)this.getValue(index)).longValue();
        }
        return null;
    }

    @Override
    public boolean isValidFloat(int index) {
        Short value = (Short)this.getValue(index);
        return value != null && (float)value.shortValue() <= Float.MAX_VALUE && (float)value.shortValue() >= Float.MIN_VALUE;
    }

    @Override
    public Float getFloat(int index) {
        if (this.isValidFloat(index)) {
            return Float.valueOf(((Short)this.getValue(index)).floatValue());
        }
        return null;
    }

    @Override
    public boolean isValidDouble(int index) {
        Short value = (Short)this.getValue(index);
        return value != null && (double)value.shortValue() <= Double.MAX_VALUE && (double)value.shortValue() >= Double.MIN_VALUE;
    }

    @Override
    public Double getDouble(int index) {
        if (this.isValidDouble(index)) {
            return ((Short)this.getValue(index)).doubleValue();
        }
        return null;
    }

    @Override
    public boolean isValidBigDecimal(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return new BigDecimal(((Short)this.getValue(index)).shortValue());
    }
}

