/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.isotp.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.plc4x.java.api.exceptions.PlcProtocolPayloadTooBigException;
import org.apache.plc4x.java.base.PlcMessageToMessageCodec;
import org.apache.plc4x.java.base.events.ConnectEvent;
import org.apache.plc4x.java.isoontcp.protocol.IsoOnTcpProtocol;
import org.apache.plc4x.java.isoontcp.protocol.model.IsoOnTcpMessage;
import org.apache.plc4x.java.isotp.protocol.events.IsoTPConnectedEvent;
import org.apache.plc4x.java.isotp.protocol.model.IsoTPMessage;
import org.apache.plc4x.java.isotp.protocol.model.params.CalledTsapParameter;
import org.apache.plc4x.java.isotp.protocol.model.params.CallingTsapParameter;
import org.apache.plc4x.java.isotp.protocol.model.params.ChecksumParameter;
import org.apache.plc4x.java.isotp.protocol.model.params.DisconnectAdditionalInformationParameter;
import org.apache.plc4x.java.isotp.protocol.model.params.Parameter;
import org.apache.plc4x.java.isotp.protocol.model.params.TpduSizeParameter;
import org.apache.plc4x.java.isotp.protocol.model.params.TsapParameter;
import org.apache.plc4x.java.isotp.protocol.model.tpdus.ConnectionConfirmTpdu;
import org.apache.plc4x.java.isotp.protocol.model.tpdus.ConnectionRequestTpdu;
import org.apache.plc4x.java.isotp.protocol.model.tpdus.ConnectionTpdu;
import org.apache.plc4x.java.isotp.protocol.model.tpdus.DataTpdu;
import org.apache.plc4x.java.isotp.protocol.model.tpdus.DisconnectConfirmTpdu;
import org.apache.plc4x.java.isotp.protocol.model.tpdus.DisconnectRequestTpdu;
import org.apache.plc4x.java.isotp.protocol.model.tpdus.DisconnectTpdu;
import org.apache.plc4x.java.isotp.protocol.model.tpdus.ErrorTpdu;
import org.apache.plc4x.java.isotp.protocol.model.tpdus.Tpdu;
import org.apache.plc4x.java.isotp.protocol.model.types.DisconnectReason;
import org.apache.plc4x.java.isotp.protocol.model.types.ParameterCode;
import org.apache.plc4x.java.isotp.protocol.model.types.ProtocolClass;
import org.apache.plc4x.java.isotp.protocol.model.types.RejectCause;
import org.apache.plc4x.java.isotp.protocol.model.types.TpduCode;
import org.apache.plc4x.java.isotp.protocol.model.types.TpduSize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsoTPProtocol
extends PlcMessageToMessageCodec<IsoOnTcpMessage, Tpdu> {
    private static final Logger logger = LoggerFactory.getLogger(IsoTPProtocol.class);
    private short callingTsapId;
    private short calledTsapId;
    private TpduSize tpduSize;

    public IsoTPProtocol(short callingTsapId, short calledTsapId, TpduSize tpduSize) {
        this.callingTsapId = callingTsapId;
        this.calledTsapId = calledTsapId;
        this.tpduSize = tpduSize;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        ChannelHandler prevHandler = this.getPrevChannelHandler(ctx);
        if (prevHandler instanceof IsoOnTcpProtocol && evt instanceof ConnectEvent) {
            logger.debug("ISO Transport Protocol Sending Connection Request");
            ConnectionRequestTpdu connectionRequest = new ConnectionRequestTpdu(0, 15, ProtocolClass.CLASS_0, Arrays.asList(new CalledTsapParameter(this.calledTsapId), new CallingTsapParameter(this.callingTsapId), new TpduSizeParameter(this.tpduSize)), Unpooled.buffer());
            ctx.channel().writeAndFlush((Object)connectionRequest);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    protected void encode(ChannelHandlerContext ctx, Tpdu in, List<Object> out) {
        logger.trace("ISO Transport Protocol Message sent");
        if (in == null) {
            return;
        }
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte((int)((byte)(this.getHeaderLength(in) - 1)));
        buf.writeByte((int)in.getTpduCode().getCode());
        switch (in.getTpduCode()) {
            case CONNECTION_REQUEST: 
            case CONNECTION_CONFIRM: {
                this.encodeConnectionTpdu(in, buf);
                break;
            }
            case DATA: {
                this.encodeDataTpdu((DataTpdu)in, buf);
                break;
            }
            case DISCONNECT_REQUEST: 
            case DISCONNECT_CONFIRM: {
                this.encodeDisconnectTpdu(in, buf);
                break;
            }
            case TPDU_ERROR: {
                this.encodeErrorTpdu(in, buf);
                break;
            }
            default: {
                if (logger.isErrorEnabled()) {
                    logger.error("TDPU Value {} not implemented yet", (Object)in.getTpduCode().name());
                }
                return;
            }
        }
        buf.writeBytes(in.getUserData());
        if (buf.writerIndex() > this.tpduSize.getValue()) {
            ctx.fireExceptionCaught((Throwable)new PlcProtocolPayloadTooBigException("iso-tp", this.tpduSize.getValue(), buf.writerIndex(), (Object)in));
        } else {
            out.add(new IsoOnTcpMessage(buf));
        }
    }

    private void encodeErrorTpdu(Tpdu in, ByteBuf buf) {
        ErrorTpdu errorTpdu = (ErrorTpdu)in;
        buf.writeShort((int)errorTpdu.getDestinationReference());
        buf.writeByte((int)errorTpdu.getRejectCause().getCode());
        this.encodeParameters(buf, in.getParameters());
    }

    private void encodeDisconnectTpdu(Tpdu in, ByteBuf buf) {
        DisconnectTpdu disconnectTpdu = (DisconnectTpdu)in;
        buf.writeShort((int)disconnectTpdu.getDestinationReference());
        buf.writeShort((int)disconnectTpdu.getSourceReference());
        if (disconnectTpdu instanceof DisconnectRequestTpdu) {
            DisconnectRequestTpdu disconnectRequestTpdu = (DisconnectRequestTpdu)disconnectTpdu;
            buf.writeByte((int)disconnectRequestTpdu.getDisconnectReason().getCode());
        }
        this.encodeParameters(buf, in.getParameters());
    }

    private void encodeDataTpdu(DataTpdu in, ByteBuf buf) {
        buf.writeByte((int)((byte)(in.getTpduRef() | (in.isEot() ? 128 : 0))));
    }

    private void encodeConnectionTpdu(Tpdu in, ByteBuf buf) {
        ConnectionTpdu connectionTpdu = (ConnectionTpdu)in;
        buf.writeShort((int)connectionTpdu.getDestinationReference());
        buf.writeShort((int)connectionTpdu.getSourceReference());
        buf.writeByte((int)connectionTpdu.getProtocolClass().getCode());
        this.encodeParameters(buf, in.getParameters());
    }

    private void encodeParameters(ByteBuf out, List<Parameter> parameters) {
        if (parameters == null) {
            return;
        }
        block6: for (Parameter parameter : parameters) {
            out.writeByte((int)parameter.getType().getCode());
            out.writeByte((int)((byte)(this.getParameterLength(parameter) - 2)));
            switch (parameter.getType()) {
                case CALLED_TSAP: 
                case CALLING_TSAP: {
                    TsapParameter tsap = (TsapParameter)parameter;
                    out.writeShort((int)tsap.getTsapId());
                    continue block6;
                }
                case CHECKSUM: {
                    ChecksumParameter checksum = (ChecksumParameter)parameter;
                    out.writeByte((int)checksum.getChecksum());
                    continue block6;
                }
                case DISCONNECT_ADDITIONAL_INFORMATION: {
                    DisconnectAdditionalInformationParameter disconnectAdditionalInformation = (DisconnectAdditionalInformationParameter)parameter;
                    out.writeBytes(disconnectAdditionalInformation.getData());
                    continue block6;
                }
                case TPDU_SIZE: {
                    TpduSizeParameter sizeParameter = (TpduSizeParameter)parameter;
                    out.writeByte((int)sizeParameter.getTpduSize().getCode());
                    continue block6;
                }
            }
            if (logger.isErrorEnabled()) {
                logger.error("TDPU tarameter type {} not implemented yet", (Object)parameter.getType().name());
            }
            return;
        }
    }

    protected void decode(ChannelHandlerContext ctx, IsoOnTcpMessage in, List<Object> out) {
        ByteBuf userData;
        logger.trace("ISO TP Message received");
        if (in == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Got Data: {}", (Object)ByteBufUtil.hexDump((ByteBuf)in.getUserData()));
        }
        if ((userData = in.getUserData()).writerIndex() < 1) {
            return;
        }
        int packetStart = userData.readerIndex();
        byte headerLength = userData.readByte();
        int headerEnd = packetStart + headerLength;
        TpduCode tpduCode = TpduCode.valueOf(userData.readByte());
        Tpdu tpdu = null;
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        switch (tpduCode) {
            case CONNECTION_REQUEST: 
            case CONNECTION_CONFIRM: {
                tpdu = this.decodeConnectTpdu(ctx, userData, tpduCode, parameters);
                break;
            }
            case DATA: {
                tpdu = this.decodeDataTpdu(userData, parameters);
                break;
            }
            case DISCONNECT_REQUEST: 
            case DISCONNECT_CONFIRM: {
                tpdu = this.decodeDisconnectTpdu(userData, tpduCode, parameters);
                break;
            }
            case TPDU_ERROR: {
                tpdu = this.decodeErrorTpdu(userData, parameters);
                break;
            }
            default: {
                if (!logger.isErrorEnabled()) break;
                logger.error("Tpdu Code {} not implemented", (Object)tpduCode.name());
            }
        }
        while (userData.readerIndex() < headerEnd) {
            Parameter parameter = this.decodeParameter(userData);
            if (parameter == null) continue;
            parameters.add(parameter);
        }
        if (tpdu != null) {
            if (tpdu instanceof ConnectionConfirmTpdu) {
                tpdu.getParameter(CalledTsapParameter.class).ifPresent(calledTsapParameter -> {
                    this.calledTsapId = calledTsapParameter.getTsapId();
                });
                tpdu.getParameter(TpduSizeParameter.class).ifPresent(tpduSizeParameter -> {
                    this.tpduSize = tpduSizeParameter.getTpduSize();
                });
            }
            out.add((Object)new IsoTPMessage(tpdu, userData));
        }
    }

    private Tpdu decodeErrorTpdu(ByteBuf userData, List<Parameter> parameters) {
        short destinationReference = userData.readShort();
        RejectCause rejectCause = RejectCause.valueOf(userData.readByte());
        ErrorTpdu tpdu = new ErrorTpdu(destinationReference, rejectCause, parameters, userData);
        return tpdu;
    }

    private Tpdu decodeDisconnectTpdu(ByteBuf userData, TpduCode tpduCode, List<Parameter> parameters) {
        DisconnectTpdu tpdu;
        short destinationReference = userData.readShort();
        short sourceReference = userData.readShort();
        if (tpduCode == TpduCode.DISCONNECT_REQUEST) {
            DisconnectReason disconnectReason = DisconnectReason.valueOf(userData.readByte());
            tpdu = new DisconnectRequestTpdu(destinationReference, sourceReference, disconnectReason, parameters, userData);
        } else {
            tpdu = new DisconnectConfirmTpdu(destinationReference, sourceReference, parameters, userData);
        }
        return tpdu;
    }

    private Tpdu decodeDataTpdu(ByteBuf userData, List<Parameter> parameters) {
        byte tmp = userData.readByte();
        boolean eot = (tmp & 0x80) == 128;
        byte tpduRef = (byte)(tmp & 0x7F);
        DataTpdu tpdu = new DataTpdu(eot, tpduRef, parameters, userData);
        return tpdu;
    }

    private Tpdu decodeConnectTpdu(ChannelHandlerContext ctx, ByteBuf userData, TpduCode tpduCode, List<Parameter> parameters) {
        ConnectionTpdu tpdu;
        short destinationReference = userData.readShort();
        short sourceReference = userData.readShort();
        ProtocolClass protocolClass = ProtocolClass.valueOf(userData.readByte());
        if (tpduCode == TpduCode.CONNECTION_REQUEST) {
            tpdu = new ConnectionRequestTpdu(destinationReference, sourceReference, protocolClass, parameters, userData);
        } else {
            tpdu = new ConnectionConfirmTpdu(destinationReference, sourceReference, protocolClass, parameters, userData);
            ctx.channel().pipeline().fireUserEventTriggered((Object)new IsoTPConnectedEvent());
        }
        return tpdu;
    }

    private Parameter decodeParameter(ByteBuf out) {
        ParameterCode parameterCode = ParameterCode.valueOf(out.readByte());
        if (parameterCode == null) {
            logger.error("Could not find parameter code");
            return null;
        }
        byte length = out.readByte();
        switch (parameterCode) {
            case CALLED_TSAP: 
            case CALLING_TSAP: {
                return this.decodeTsapParameter(out, parameterCode);
            }
            case CHECKSUM: {
                byte checksum = out.readByte();
                return new ChecksumParameter(checksum);
            }
            case DISCONNECT_ADDITIONAL_INFORMATION: {
                byte[] data = new byte[length];
                out.readBytes(data);
                return new DisconnectAdditionalInformationParameter(data);
            }
            case TPDU_SIZE: {
                TpduSize size = TpduSize.valueOf(out.readByte());
                return new TpduSizeParameter(size);
            }
        }
        if (logger.isErrorEnabled()) {
            logger.error("Parameter not implemented yet {}", (Object)parameterCode.name());
        }
        return null;
    }

    private Parameter decodeTsapParameter(ByteBuf out, ParameterCode parameterCode) {
        short tsapId = out.readShort();
        switch (parameterCode) {
            case CALLING_TSAP: {
                return new CallingTsapParameter(tsapId);
            }
            case CALLED_TSAP: {
                return new CalledTsapParameter(tsapId);
            }
        }
        if (logger.isErrorEnabled()) {
            logger.error("Parameter not implemented yet {}", (Object)parameterCode.name());
        }
        return null;
    }

    private short getHeaderLength(Tpdu tpdu) {
        int headerLength;
        if (tpdu == null) {
            return 0;
        }
        switch (tpdu.getTpduCode()) {
            case CONNECTION_REQUEST: 
            case CONNECTION_CONFIRM: {
                headerLength = 7;
                break;
            }
            case DATA: {
                headerLength = 3;
                break;
            }
            case DISCONNECT_REQUEST: {
                headerLength = 7;
                break;
            }
            case DISCONNECT_CONFIRM: {
                headerLength = 6;
                break;
            }
            case TPDU_ERROR: {
                headerLength = 5;
                break;
            }
            default: {
                headerLength = 0;
            }
        }
        return (short)(headerLength + this.getParametersLength(tpdu.getParameters()));
    }

    private short getParametersLength(List<Parameter> parameters) {
        short length = 0;
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                length = (short)(length + this.getParameterLength(parameter));
            }
        }
        return length;
    }

    private short getParameterLength(Parameter parameter) {
        if (parameter == null) {
            return 0;
        }
        switch (parameter.getType()) {
            case CALLED_TSAP: 
            case CALLING_TSAP: {
                return 4;
            }
            case CHECKSUM: {
                return 3;
            }
            case DISCONNECT_ADDITIONAL_INFORMATION: {
                DisconnectAdditionalInformationParameter disconnectAdditionalInformationParameter = (DisconnectAdditionalInformationParameter)parameter;
                return (short)(2 + (disconnectAdditionalInformationParameter.getData() != null ? disconnectAdditionalInformationParameter.getData().length : 0));
            }
            case TPDU_SIZE: {
                return 3;
            }
        }
        return 0;
    }
}

