/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.isotp.protocol.model.tpdus;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import org.apache.plc4x.java.base.messages.PlcProtocolMessage;
import org.apache.plc4x.java.base.messages.PlcRawMessage;
import org.apache.plc4x.java.isotp.protocol.model.params.Parameter;
import org.apache.plc4x.java.isotp.protocol.model.types.TpduCode;

public abstract class Tpdu
extends PlcRawMessage {
    private final TpduCode tpduCode;
    private final List<Parameter> parameters;

    public Tpdu(TpduCode tpduCode, List<Parameter> parameters, ByteBuf userData) {
        this(tpduCode, parameters, userData, null);
    }

    public Tpdu(TpduCode tpduCode, List<Parameter> parameters, ByteBuf userData, PlcProtocolMessage parent) {
        super(userData, parent);
        this.tpduCode = tpduCode;
        this.parameters = parameters;
    }

    public TpduCode getTpduCode() {
        return this.tpduCode;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public <T extends Parameter> Optional<T> getParameter(Class<T> parameterClass) {
        if (this.parameters != null) {
            for (Parameter parameter : this.parameters) {
                if (parameter.getClass() != parameterClass) continue;
                return Optional.of(parameterClass.cast(parameter));
            }
        }
        return Optional.empty();
    }
}

