/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.log4j.Logger;

public class RangerAccessControlLists {
    private static final Logger LOG = Logger.getLogger(RangerAccessControlLists.class);

    public static void init(MasterServices master) throws IOException {
        Class<AccessControlLists> accessControlListsClass = AccessControlLists.class;
        String cName = accessControlListsClass.getName();
        Class[] params = new Class[]{MasterServices.class};
        for (String mname : new String[]{"init", "createACLTable"}) {
            try {
                try {
                    Method m = accessControlListsClass.getDeclaredMethod(mname, params);
                    if (m == null) continue;
                    try {
                        block12: {
                            try {
                                m.invoke(null, master);
                                RangerAccessControlLists.logInfo("Execute method name [" + mname + "] in Class [" + cName + "] is successful.");
                            }
                            catch (InvocationTargetException e) {
                                Throwable ecause;
                                Throwable cause = e;
                                boolean tableExistsExceptionFound = false;
                                if (e != null && (ecause = e.getTargetException()) != null) {
                                    cause = ecause;
                                    if (ecause instanceof TableExistsException) {
                                        tableExistsExceptionFound = true;
                                    }
                                }
                                if (tableExistsExceptionFound) break block12;
                                RangerAccessControlLists.logError("Unable to execute the method [" + mname + "] on [" + cName + "] due to exception", cause);
                                throw new IOException(cause);
                            }
                        }
                        return;
                    }
                    catch (IllegalArgumentException e) {
                        RangerAccessControlLists.logError("Unable to execute method name [" + mname + "] in Class [" + cName + "].", e);
                        throw new IOException(e);
                    }
                    catch (IllegalAccessException e) {
                        RangerAccessControlLists.logError("Unable to execute method name [" + mname + "] in Class [" + cName + "].", e);
                        throw new IOException(e);
                    }
                }
                catch (NoSuchMethodException nsme) {
                    RangerAccessControlLists.logInfo("Unable to get method name [" + mname + "] in Class [" + cName + "]. Ignoring the exception");
                }
            }
            catch (SecurityException e) {
                RangerAccessControlLists.logError("Unable to get method name [" + mname + "] in Class [" + cName + "].", e);
                throw new IOException(e);
            }
        }
        throw new IOException("Unable to initialize() [" + cName + "]");
    }

    private static void logInfo(String msg) {
        LOG.info((Object)msg);
    }

    private static void logError(String msg, Throwable t) {
        LOG.error((Object)msg, t);
    }
}

