/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hbase;

import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BulkLoadObserver;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.protobuf.generated.SecureBulkLoadProtos;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;

public class RangerAuthorizationCoprocessor
implements MasterObserver,
RegionObserver,
RegionServerObserver,
BulkLoadObserver,
AccessControlProtos.AccessControlService.Interface,
CoprocessorService,
Coprocessor {
    public static final Log LOG = LogFactory.getLog(RangerAuthorizationCoprocessor.class);
    private static final String RANGER_PLUGIN_TYPE = "hbase";
    private static final String RANGER_HBASE_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.hbase.RangerAuthorizationCoprocessor";
    private static RangerPluginClassLoader rangerPluginClassLoader = null;
    private Object impl = null;
    private MasterObserver implMasterObserver = null;
    private RegionObserver implRegionObserver = null;
    private RegionServerObserver implRegionServerObserver = null;
    private BulkLoadObserver implBulkLoadObserver = null;
    private AccessControlProtos.AccessControlService.Interface implAccessControlService = null;
    private CoprocessorService implCoprocessorService = null;

    public RangerAuthorizationCoprocessor() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.RangerAuthorizationCoprocessor()");
        }
        this.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.RangerAuthorizationCoprocessor()");
        }
    }

    private void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.init()");
        }
        try {
            rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_HBASE_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)rangerPluginClassLoader);
            this.activatePluginClassLoader();
            this.impl = cls.newInstance();
            this.implMasterObserver = (MasterObserver)this.impl;
            this.implRegionObserver = (RegionObserver)this.impl;
            this.implRegionServerObserver = (RegionServerObserver)this.impl;
            this.implBulkLoadObserver = (BulkLoadObserver)this.impl;
            this.implAccessControlService = (AccessControlProtos.AccessControlService.Interface)this.impl;
            this.implCoprocessorService = (CoprocessorService)this.impl;
        }
        catch (Exception e) {
            LOG.error((Object)"Error Enabling RangerHbasePlugin", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.init()");
        }
    }

    public Service getService() {
        Service ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.getService()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implCoprocessorService.getService();
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAuthorizationCoprocessor.getService()" + ret));
        }
        return ret;
    }

    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postScannerClose()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postScannerClose(c, s);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postScannerClose()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        RegionScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postScannerOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postScannerOpen(c, scan, s);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postScannerOpen()");
        }
        return ret;
    }

    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postStartMaster()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postStartMaster(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postStartMaster()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preAddColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor column) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preAddColumn()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preAddColumn(c, tableName, column);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preAddColumn()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preAppend()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preAppend(c, append);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preAppend()");
        }
        return ret;
    }

    public void preAssign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preAssign()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preAssign(c, regionInfo);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preAssign()");
        }
    }

    public void preBalance(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preBalance()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preBalance(c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preBalance()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean newValue) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preBalanceSwitch()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implMasterObserver.preBalanceSwitch(c, newValue);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preBalanceSwitch()");
        }
        return ret;
    }

    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preBulkLoadHFile()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preBulkLoadHFile(ctx, familyPaths);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preBulkLoadHFile()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preCheckAndDelete()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCheckAndDelete(c, row, family, qualifier, compareOp, comparator, delete, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preCheckAndDelete()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preCheckAndPut()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCheckAndPut(c, row, family, qualifier, compareOp, comparator, put, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preCheckAndPut()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preCloneSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preCloneSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preCloneSnapshot()");
        }
    }

    public void preClose(ObserverContext<RegionCoprocessorEnvironment> e, boolean abortRequested) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preClose()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preClose(e, abortRequested);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preClose()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, InternalScanner scanner, ScanType scanType) throws IOException {
        InternalScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preCompact()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCompact(e, store, scanner, scanType);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preCompact()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> e, Store store, List<StoreFile> candidates) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preCompactSelection()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preCompactSelection(e, store, candidates);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preCompactSelection()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preCreateTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preCreateTable(c, desc, regions);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preCreateTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preDelete()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preDelete(c, delete, edit, durability);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preDelete()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, byte[] col) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preDeleteColumn()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDeleteColumn(c, tableName, col);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preDeleteColumn()");
        }
    }

    public void preDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preDeleteSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDeleteSnapshot(ctx, snapshot);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preDeleteSnapshot()");
        }
    }

    public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preDeleteTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDeleteTable(c, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preDeleteTable()");
        }
    }

    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preDisableTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDisableTable(c, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preDisableTable()");
        }
    }

    public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preEnableTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preEnableTable(c, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preEnableTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preExists(ObserverContext<RegionCoprocessorEnvironment> c, Get get, boolean exists) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preExists()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preExists(c, get, exists);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preExists()");
        }
        return ret;
    }

    public void preFlush(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preFlush()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preFlush(e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preFlush()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preGetClosestRowBefore(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, Result result) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preGetClosestRowBefore()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preGetClosestRowBefore(c, row, family, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preGetClosestRowBefore()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preIncrement()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preIncrement(c, increment);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preIncrement()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long preIncrementColumnValue(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        long ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preIncrementColumnValue()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preIncrementColumnValue(c, row, family, qualifier, amount, writeToWAL);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preIncrementColumnValue()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preModifyColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor descriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preModifyColumn()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preModifyColumn(c, tableName, descriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preModifyColumn()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HTableDescriptor htd) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preModifyTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preModifyTable(c, tableName, htd);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preModifyTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preMove(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preMove()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preMove(c, region, srcServer, destServer);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preMove()");
        }
    }

    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preOpen()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preOpen(e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preOpen()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preRestoreSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preRestoreSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preRestoreSnapshot()");
        }
    }

    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preScannerClose()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preScannerClose(c, s);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preScannerClose()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preScannerNext()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preScannerNext(c, s, result, limit, hasNext);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preScannerNext()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        RegionScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preScannerOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preScannerOpen(c, scan, s);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preScannerOpen()");
        }
        return ret;
    }

    public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preShutdown()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preShutdown(c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preShutdown()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preSnapshot()");
        }
    }

    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preSplit()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preSplit(e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preSplit()");
        }
    }

    public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preStopMaster()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preStopMaster(c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preStopMaster()");
        }
    }

    public void preStopRegionServer(ObserverContext<RegionServerCoprocessorEnvironment> env) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preStopRegionServer()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.preStopRegionServer(env);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preStopRegionServer()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo, boolean force) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preUnassign()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preUnassign(c, regionInfo, force);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preUnassign()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSetUserQuota(ctx, userName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, TableName tableName, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSetUserQuota(ctx, userName, tableName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, String namespace, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSetUserQuota(ctx, userName, namespace, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSetTableQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preSetTableQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSetTableQuota(ctx, tableName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preSetTableQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSetNamespaceQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preSetNamespaceQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSetNamespaceQuota(ctx, namespace, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preSetNamespaceQuota()");
        }
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.start()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.start(env);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.start()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.prePut()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.prePut(c, put, edit, durability);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.prePut()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> rEnv, Get get, List<Cell> result) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preGetOp()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preGetOp(rEnv, get, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preGetOp()");
        }
    }

    public void preRegionOffline(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preRegionOffline()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preRegionOffline(c, regionInfo);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preRegionOffline()");
        }
    }

    public void preCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preCreateNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preCreateNamespace(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preCreateNamespace()");
        }
    }

    public void preDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preDeleteNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDeleteNamespace(ctx, namespace);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preDeleteNamespace()");
        }
    }

    public void preModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preModifyNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preModifyNamespace(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preModifyNamespace()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors, String regex) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postGetTableDescriptors()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postGetTableDescriptors(ctx, tableNamesList, descriptors, regex);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postGetTableDescriptors()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preMerge()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.preMerge(ctx, regionA, regionB);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preMerge()");
        }
    }

    public void prePrepareBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx, SecureBulkLoadProtos.PrepareBulkLoadRequest request) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.prePrepareBulkLoad()");
        }
        try {
            this.activatePluginClassLoader();
            this.implBulkLoadObserver.prePrepareBulkLoad(ctx, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.prePrepareBulkLoad()");
        }
    }

    public void preCleanupBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx, SecureBulkLoadProtos.CleanupBulkLoadRequest request) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preCleanupBulkLoad()");
        }
        try {
            this.activatePluginClassLoader();
            this.implBulkLoadObserver.preCleanupBulkLoad(ctx, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preCleanupBulkLoad()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grant(RpcController controller, AccessControlProtos.GrantRequest request, RpcCallback<AccessControlProtos.GrantResponse> done) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.grant()");
        }
        try {
            this.activatePluginClassLoader();
            this.implAccessControlService.grant(controller, request, done);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.grant()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revoke(RpcController controller, AccessControlProtos.RevokeRequest request, RpcCallback<AccessControlProtos.RevokeResponse> done) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.revoke()");
        }
        try {
            this.activatePluginClassLoader();
            this.implAccessControlService.revoke(controller, request, done);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.revoke()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPermissions(RpcController controller, AccessControlProtos.CheckPermissionsRequest request, RpcCallback<AccessControlProtos.CheckPermissionsResponse> done) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.checkPermissions()");
        }
        try {
            this.activatePluginClassLoader();
            this.implAccessControlService.checkPermissions(controller, request, done);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.checkPermissions()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getUserPermissions(RpcController controller, AccessControlProtos.GetUserPermissionsRequest request, RpcCallback<AccessControlProtos.GetUserPermissionsResponse> done) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.getUserPermissions()");
        }
        try {
            this.activatePluginClassLoader();
            this.implAccessControlService.getUserPermissions(controller, request, done);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.getUserPermissions()");
        }
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.stop()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.stop(env);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.stop()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMerge(ObserverContext<RegionServerCoprocessorEnvironment> c, Region regionA, Region regionB, Region mergedRegion) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postMerge()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.postMerge(c, regionA, regionB, mergedRegion);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postMerge()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preMergeCommit(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB, List<Mutation> metaEntries) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preMergeCommit()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.preMergeCommit(ctx, regionA, regionB, metaEntries);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preMergeCommit()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMergeCommit(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB, Region mergedRegion) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postMergeCommit()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.postMergeCommit(ctx, regionA, regionB, mergedRegion);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postMergeCommit()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRollBackMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preRollBackMerge()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.preRollBackMerge(ctx, regionA, regionB);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preRollBackMerge()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRollBackMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postRollBackMerge()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.postRollBackMerge(ctx, regionA, regionB);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postRollBackMerge()");
        }
    }

    public void preRollWALWriterRequest(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preRollWALWriterRequest()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.preRollWALWriterRequest(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preRollWALWriterRequest()");
        }
    }

    public void postRollWALWriterRequest(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postRollWALWriterRequest()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.postRollWALWriterRequest(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postRollWALWriterRequest()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationEndpoint postCreateReplicationEndPoint(ObserverContext<RegionServerCoprocessorEnvironment> ctx, ReplicationEndpoint endpoint) {
        ReplicationEndpoint ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postCreateReplicationEndPoint()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionServerObserver.postCreateReplicationEndPoint(ctx, endpoint);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postCreateReplicationEndPoint()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preReplicateLogEntries(ObserverContext<RegionServerCoprocessorEnvironment> ctx, List<AdminProtos.WALEntry> entries, CellScanner cells) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preReplicateLogEntries()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.preReplicateLogEntries(ctx, entries, cells);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preReplicateLogEntries()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postReplicateLogEntries(ObserverContext<RegionServerCoprocessorEnvironment> ctx, List<AdminProtos.WALEntry> entries, CellScanner cells) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postReplicateLogEntries()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.postReplicateLogEntries(ctx, entries, cells);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postReplicateLogEntries()");
        }
    }

    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postOpen()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postOpen(c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postOpen()");
        }
    }

    public void postLogReplay(ObserverContext<RegionCoprocessorEnvironment> c) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postLogReplay()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postLogReplay(c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postLogReplay()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preFlushScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, KeyValueScanner memstoreScanner, InternalScanner s) throws IOException {
        InternalScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preFlushScannerOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preFlushScannerOpen(c, store, memstoreScanner, s);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preFlushScannerOpen()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner) throws IOException {
        InternalScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preFlush()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preFlush(c, store, scanner);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preFlush()");
        }
        return ret;
    }

    public void postFlush(ObserverContext<RegionCoprocessorEnvironment> c) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postFlush()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postFlush(c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postFlush()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postFlush()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postFlush(c, store, resultFile);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postFlush()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<StoreFile> candidates, CompactionRequest request) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preCompactSelection()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preCompactSelection(c, store, candidates, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preCompactSelection()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ImmutableList<StoreFile> selected, CompactionRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postCompactSelection()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postCompactSelection(c, store, selected, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postCompactSelection()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ImmutableList<StoreFile> selected) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postCompactSelection()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postCompactSelection(c, store, selected);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postCompactSelection()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, ScanType scanType, CompactionRequest request) throws IOException {
        InternalScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preCompact()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCompact(c, store, scanner, scanType, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preCompact()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends KeyValueScanner> scanners, ScanType scanType, long earliestPutTs, InternalScanner s, CompactionRequest request) throws IOException {
        InternalScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preCompactScannerOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCompactScannerOpen(c, store, scanners, scanType, earliestPutTs, s, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preCompactScannerOpen()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends KeyValueScanner> scanners, ScanType scanType, long earliestPutTs, InternalScanner s) throws IOException {
        InternalScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preCompactScannerOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCompactScannerOpen(c, store, scanners, scanType, earliestPutTs, s);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preCompactScannerOpen()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile, CompactionRequest request) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postCompact()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postCompact(c, store, resultFile, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postCompact()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postCompact()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postCompact(c, store, resultFile);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postCompact()");
        }
    }

    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> c, byte[] splitRow) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preSplit()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preSplit(c, splitRow);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preSplit()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSplit(ObserverContext<RegionCoprocessorEnvironment> c, Region l, Region r) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postSplit()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postSplit(c, l, r);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postSplit()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSplitBeforePONR(ObserverContext<RegionCoprocessorEnvironment> ctx, byte[] splitKey, List<Mutation> metaEntries) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preSplitBeforePONR()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preSplitBeforePONR(ctx, splitKey, metaEntries);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preSplitBeforePONR()");
        }
    }

    public void preSplitAfterPONR(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preSplitAfterPONR()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preSplitAfterPONR(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preSplitAfterPONR()");
        }
    }

    public void preRollBackSplit(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preRollBackSplit()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preRollBackSplit(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preRollBackSplit()");
        }
    }

    public void postRollBackSplit(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postRollBackSplit()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postRollBackSplit(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postRollBackSplit()");
        }
    }

    public void postCompleteSplit(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postCompleteSplit()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postCompleteSplit(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postCompleteSplit()");
        }
    }

    public void postClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postClose()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postClose(c, abortRequested);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postClose()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postGetClosestRowBefore(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, Result result) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postGetClosestRowBefore()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postGetClosestRowBefore(c, row, family, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postGetClosestRowBefore()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postGetOp()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postGetOp(c, get, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postGetOp()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postExists(ObserverContext<RegionCoprocessorEnvironment> c, Get get, boolean exists) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postExists()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postExists(c, get, exists);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postExists()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postPut()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postPut(c, put, edit, durability);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postPut()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prePrepareTimeStampForDeleteVersion(ObserverContext<RegionCoprocessorEnvironment> c, Mutation mutation, Cell cell, byte[] byteNow, Get get) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.prePrepareTimeStampForDeleteVersion()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.prePrepareTimeStampForDeleteVersion(c, mutation, cell, byteNow, get);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.prePrepareTimeStampForDeleteVersion()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postDelete()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postDelete(c, delete, edit, durability);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postDelete()");
        }
    }

    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preBatchMutate()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preBatchMutate(c, miniBatchOp);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preBatchMutate()");
        }
    }

    public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postBatchMutate()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postBatchMutate(c, miniBatchOp);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postBatchMutate()");
        }
    }

    public void postStartRegionOperation(ObserverContext<RegionCoprocessorEnvironment> ctx, Region.Operation operation) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postStartRegionOperation()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postStartRegionOperation(ctx, operation);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postStartRegionOperation()");
        }
    }

    public void postCloseRegionOperation(ObserverContext<RegionCoprocessorEnvironment> ctx, Region.Operation operation) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postCloseRegionOperation()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postCloseRegionOperation(ctx, operation);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postCloseRegionOperation()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBatchMutateIndispensably(ObserverContext<RegionCoprocessorEnvironment> ctx, MiniBatchOperationInProgress<Mutation> miniBatchOp, boolean success) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postBatchMutateIndispensably()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postBatchMutateIndispensably(ctx, miniBatchOp, success);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postBatchMutateIndispensably()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preCheckAndPutAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preCheckAndPutAfterRowLock()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCheckAndPutAfterRowLock(c, row, family, qualifier, compareOp, comparator, put, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preCheckAndPutAfterRowLock()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postCheckAndPut()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postCheckAndPut(c, row, family, qualifier, compareOp, comparator, put, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postCheckAndPut()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preCheckAndDeleteAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preCheckAndDeleteAfterRowLock()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCheckAndDeleteAfterRowLock(c, row, family, qualifier, compareOp, comparator, delete, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preCheckAndDeleteAfterRowLock()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postCheckAndDelete()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postCheckAndDelete(c, row, family, qualifier, compareOp, comparator, delete, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postCheckAndDelete()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long postIncrementColumnValue(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL, long result) throws IOException {
        long ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postIncrementColumnValue()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postIncrementColumnValue(c, row, family, qualifier, amount, writeToWAL, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postIncrementColumnValue()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result preAppendAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preAppendAfterRowLock()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preAppendAfterRowLock(c, append);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preAppendAfterRowLock()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result postAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append, Result result) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postAppend()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postAppend(c, append, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postAppend()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result preIncrementAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preIncrementAfterRowLock()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preIncrementAfterRowLock(c, increment);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preIncrementAfterRowLock()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result postIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment, Result result) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postIncrement()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postIncrement(c, increment, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postIncrement()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyValueScanner preStoreScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, Scan scan, NavigableSet<byte[]> targetCols, KeyValueScanner s) throws IOException {
        KeyValueScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preStoreScannerOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preStoreScannerOpen(c, store, scan, targetCols, s);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preStoreScannerOpen()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postScannerNext()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postScannerNext(c, s, result, limit, hasNext);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postScannerNext()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postScannerFilterRow(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, byte[] currentRow, int offset, short length, boolean hasMore) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postScannerFilterRow()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postScannerFilterRow(c, s, currentRow, offset, length, hasMore);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postScannerFilterRow()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preWALRestore(ObserverContext<? extends RegionCoprocessorEnvironment> ctx, HRegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preWALRestore()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preWALRestore(ctx, info, logKey, logEdit);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preWALRestore()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postWALRestore(ObserverContext<? extends RegionCoprocessorEnvironment> ctx, HRegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postWALRestore()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postWALRestore(ctx, info, logKey, logEdit);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postWALRestore()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths, boolean hasLoaded) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postBulkLoadHFile()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postBulkLoadHFile(ctx, familyPaths, hasLoaded);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postBulkLoadHFile()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreFile.Reader preStoreFileReaderOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, StoreFile.Reader reader) throws IOException {
        StoreFile.Reader ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preStoreFileReaderOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preStoreFileReaderOpen(ctx, fs, p, in, size, cacheConf, r, reader);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preStoreFileReaderOpen()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreFile.Reader postStoreFileReaderOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, StoreFile.Reader reader) throws IOException {
        StoreFile.Reader ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postStoreFileReaderOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postStoreFileReaderOpen(ctx, fs, p, in, size, cacheConf, r, reader);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postStoreFileReaderOpen()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cell postMutationBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, RegionObserver.MutationType opType, Mutation mutation, Cell oldCell, Cell newCell) throws IOException {
        Cell ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postMutationBeforeWAL()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postMutationBeforeWAL(ctx, opType, mutation, oldCell, newCell);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postMutationBeforeWAL()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeleteTracker postInstantiateDeleteTracker(ObserverContext<RegionCoprocessorEnvironment> ctx, DeleteTracker delTracker) throws IOException {
        DeleteTracker ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postInstantiateDeleteTracker()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postInstantiateDeleteTracker(ctx, delTracker);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postInstantiateDeleteTracker()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postCreateTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCreateTable(ctx, desc, regions);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postCreateTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preCreateTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preCreateTableHandler(ctx, desc, regions);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preCreateTableHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postCreateTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCreateTableHandler(ctx, desc, regions);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postCreateTableHandler()");
        }
    }

    public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postDeleteTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDeleteTable(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postDeleteTable()");
        }
    }

    public void preDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preDeleteTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDeleteTableHandler(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preDeleteTableHandler()");
        }
    }

    public void postDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postDeleteTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDeleteTableHandler(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postDeleteTableHandler()");
        }
    }

    public void preTruncateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preTruncateTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preTruncateTable(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preTruncateTable()");
        }
    }

    public void postTruncateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postTruncateTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postTruncateTable(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postTruncateTable()");
        }
    }

    public void preTruncateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preTruncateTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preTruncateTableHandler(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preTruncateTableHandler()");
        }
    }

    public void postTruncateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postTruncateTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postTruncateTableHandler(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postTruncateTableHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HTableDescriptor htd) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postModifyTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postModifyTable(ctx, tableName, htd);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postModifyTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preModifyTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HTableDescriptor htd) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preModifyTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preModifyTableHandler(ctx, tableName, htd);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preModifyTableHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postModifyTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HTableDescriptor htd) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postModifyTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postModifyTableHandler(ctx, tableName, htd);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postModifyTableHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAddColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor column) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postAddColumn()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postAddColumn(ctx, tableName, column);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postAddColumn()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preAddColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor column) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preAddColumnHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preAddColumnHandler(ctx, tableName, column);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preAddColumnHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAddColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor column) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postAddColumnHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postAddColumnHandler(ctx, tableName, column);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postAddColumnHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postModifyColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor descriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postModifyColumn()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postModifyColumn(ctx, tableName, descriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postModifyColumn()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preModifyColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor descriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preModifyColumnHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preModifyColumnHandler(ctx, tableName, descriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preModifyColumnHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postModifyColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor descriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postModifyColumnHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postModifyColumnHandler(ctx, tableName, descriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postModifyColumnHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] c) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postDeleteColumn()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDeleteColumn(ctx, tableName, c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postDeleteColumn()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDeleteColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] c) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preDeleteColumnHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDeleteColumnHandler(ctx, tableName, c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preDeleteColumnHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDeleteColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] c) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postDeleteColumnHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDeleteColumnHandler(ctx, tableName, c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postDeleteColumnHandler()");
        }
    }

    public void postEnableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postEnableTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postEnableTable(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postEnableTable()");
        }
    }

    public void preEnableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preEnableTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preEnableTableHandler(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preEnableTableHandler()");
        }
    }

    public void postEnableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postEnableTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postEnableTableHandler(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postEnableTableHandler()");
        }
    }

    public void postDisableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postDisableTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDisableTable(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postDisableTable()");
        }
    }

    public void preDisableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preDisableTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDisableTableHandler(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preDisableTableHandler()");
        }
    }

    public void postDisableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postDisableTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDisableTableHandler(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postDisableTableHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMove(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postMove()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postMove(ctx, region, srcServer, destServer);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postMove()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preAbortProcedure(ObserverContext<MasterCoprocessorEnvironment> observerContext, ProcedureExecutor<MasterProcedureEnv> procEnv, long procId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preAbortProcedure()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preAbortProcedure(observerContext, procEnv, procId);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preAbortProcedure()");
        }
    }

    public void postAbortProcedure(ObserverContext<MasterCoprocessorEnvironment> observerContext) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postAbortProcedure()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postAbortProcedure(observerContext);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postAbortProcedure()");
        }
    }

    public void preListProcedures(ObserverContext<MasterCoprocessorEnvironment> observerContext) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preListProcedures()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preListProcedures(observerContext);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preListProcedures()");
        }
    }

    public void postListProcedures(ObserverContext<MasterCoprocessorEnvironment> observerContext, List<ProcedureInfo> procInfoList) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postListProcedures()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postListProcedures(observerContext, procInfoList);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postListProcedures()");
        }
    }

    public void postAssign(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postAssign()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postAssign(ctx, regionInfo);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postAssign()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postUnassign(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo, boolean force) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postUnassign()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postUnassign(ctx, regionInfo, force);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postUnassign()");
        }
    }

    public void postRegionOffline(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postRegionOffline()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postRegionOffline(ctx, regionInfo);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postRegionOffline()");
        }
    }

    public void postBalance(ObserverContext<MasterCoprocessorEnvironment> ctx, List<RegionPlan> plans) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postBalance()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postBalance(ctx, plans);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postBalance()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> ctx, boolean oldValue, boolean newValue) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postBalanceSwitch()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postBalanceSwitch(ctx, oldValue, newValue);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postBalanceSwitch()");
        }
    }

    public void preMasterInitialization(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preMasterInitialization()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preMasterInitialization(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preMasterInitialization()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postSnapshot()");
        }
    }

    public void preListSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preListSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preListSnapshot(ctx, snapshot);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preListSnapshot()");
        }
    }

    public void postListSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postListSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postListSnapshot(ctx, snapshot);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postListSnapshot()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postCloneSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCloneSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postCloneSnapshot()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postRestoreSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postRestoreSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postRestoreSnapshot()");
        }
    }

    public void postDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postDeleteSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDeleteSnapshot(ctx, snapshot);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postDeleteSnapshot()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preGetTableDescriptors()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preGetTableDescriptors(ctx, tableNamesList, descriptors);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preGetTableDescriptors()");
        }
    }

    public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postGetTableDescriptors()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postGetTableDescriptors(ctx, descriptors);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postGetTableDescriptors()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors, String regex) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preGetTableDescriptors()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preGetTableDescriptors(ctx, tableNamesList, descriptors, regex);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preGetTableDescriptors()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preGetTableNames(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors, String regex) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preGetTableNames()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preGetTableNames(ctx, descriptors, regex);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preGetTableNames()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postGetTableNames(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors, String regex) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postGetTableNames()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postGetTableNames(ctx, descriptors, regex);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postGetTableNames()");
        }
    }

    public void postCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postCreateNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCreateNamespace(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postCreateNamespace()");
        }
    }

    public void postDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postDeleteNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDeleteNamespace(ctx, namespace);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postDeleteNamespace()");
        }
    }

    public void postModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postModifyNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postModifyNamespace(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postModifyNamespace()");
        }
    }

    public void preGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preGetNamespaceDescriptor()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preGetNamespaceDescriptor(ctx, namespace);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preGetNamespaceDescriptor()");
        }
    }

    public void postGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postGetNamespaceDescriptor()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postGetNamespaceDescriptor(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postGetNamespaceDescriptor()");
        }
    }

    public void preListNamespaceDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<NamespaceDescriptor> descriptors) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preListNamespaceDescriptors()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preListNamespaceDescriptors(ctx, descriptors);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preListNamespaceDescriptors()");
        }
    }

    public void postListNamespaceDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<NamespaceDescriptor> descriptors) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postListNamespaceDescriptors()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postListNamespaceDescriptors(ctx, descriptors);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postListNamespaceDescriptors()");
        }
    }

    public void preTableFlush(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preTableFlush()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preTableFlush(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preTableFlush()");
        }
    }

    public void postTableFlush(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postTableFlush()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postTableFlush(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postTableFlush()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSetUserQuota(ctx, userName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, TableName tableName, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSetUserQuota(ctx, userName, tableName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, String namespace, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSetUserQuota(ctx, userName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetTableQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postSetTableQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSetTableQuota(ctx, tableName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postSetTableQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetNamespaceQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postSetNamespaceQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSetNamespaceQuota(ctx, namespace, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postSetNamespaceQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preWALRestore(ObserverContext<RegionCoprocessorEnvironment> ctx, HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.preWALRestore()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preWALRestore(ctx, info, logKey, logEdit);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.preWALRestore()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postWALRestore(ObserverContext<RegionCoprocessorEnvironment> ctx, HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthorizationCoprocessor.postWALRestore()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postWALRestore(ctx, info, logKey, logEdit);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthorizationCoprocessor.postWALRestore()");
        }
    }

    private void activatePluginClassLoader() {
        if (rangerPluginClassLoader != null) {
            rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (rangerPluginClassLoader != null) {
            rangerPluginClassLoader.deactivate();
        }
    }

    public void preMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<HostAndPort> servers, String targetGroup) throws IOException {
    }

    public void postMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<HostAndPort> servers, String targetGroup) throws IOException {
    }

    public void preMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
    }

    public void postMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
    }

    public void preRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void postRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void preBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName) throws IOException {
    }

    public void postBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName, boolean balancerRan) throws IOException {
    }

    public void preAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void postAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }
}

