/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.unixusersync.process;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.Subject;
import javax.ws.rs.core.MediaType;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.apache.ranger.unixusersync.model.GetXGroupListResponse;
import org.apache.ranger.unixusersync.model.GetXUserGroupListResponse;
import org.apache.ranger.unixusersync.model.GetXUserListResponse;
import org.apache.ranger.unixusersync.model.MUserInfo;
import org.apache.ranger.unixusersync.model.UserGroupInfo;
import org.apache.ranger.unixusersync.model.XGroupInfo;
import org.apache.ranger.unixusersync.model.XUserGroupInfo;
import org.apache.ranger.unixusersync.model.XUserInfo;
import org.apache.ranger.usergroupsync.UserGroupSink;
import org.apache.ranger.usersync.util.UserSyncUtil;

public class PolicyMgrUserGroupBuilder
implements UserGroupSink {
    private static final Logger LOG = Logger.getLogger(PolicyMgrUserGroupBuilder.class);
    private static final String AUTHENTICATION_TYPE = "hadoop.security.authentication";
    private String AUTH_KERBEROS = "kerberos";
    private static final String PRINCIPAL = "ranger.usersync.kerberos.principal";
    private static final String KEYTAB = "ranger.usersync.kerberos.keytab";
    private static final String NAME_RULE = "hadoop.security.auth_to_local";
    public static final String PM_USER_LIST_URI = "/service/xusers/users/";
    private static final String PM_ADD_USER_URI = "/service/xusers/users/";
    private static final String PM_ADD_USER_GROUP_INFO_URI = "/service/xusers/users/userinfo";
    public static final String PM_GROUP_LIST_URI = "/service/xusers/groups/";
    private static final String PM_ADD_GROUP_URI = "/service/xusers/groups/";
    public static final String PM_USER_GROUP_MAP_LIST_URI = "/service/xusers/groupusers/";
    private static final String PM_ADD_USER_GROUP_LINK_URI = "/service/xusers/groupusers/";
    private static final String PM_DEL_USER_GROUP_LINK_URI = "/service/xusers/group/${groupName}/user/${userName}";
    private static final String PM_ADD_LOGIN_USER_URI = "/service/users/default";
    private static final String GROUP_SOURCE_EXTERNAL = "1";
    private static String LOCAL_HOSTNAME = "unknown";
    private String recordsToPullPerCall = "1000";
    private boolean isMockRun = false;
    private String policyMgrBaseUrl;
    private UserGroupSyncConfig config = UserGroupSyncConfig.getInstance();
    private UserGroupInfo usergroupInfo = new UserGroupInfo();
    private List<XGroupInfo> xgroupList = new ArrayList<XGroupInfo>();
    private List<XUserInfo> xuserList = new ArrayList<XUserInfo>();
    private List<XUserGroupInfo> xusergroupList = new ArrayList<XUserGroupInfo>();
    private HashMap<String, XUserInfo> userId2XUserInfoMap = new HashMap();
    private HashMap<String, XUserInfo> userName2XUserInfoMap = new HashMap();
    private HashMap<String, XGroupInfo> groupName2XGroupInfoMap = new HashMap();
    private String keyStoreFile = null;
    private String keyStoreFilepwd = null;
    private String trustStoreFile = null;
    private String trustStoreFilepwd = null;
    private String keyStoreType = null;
    private String trustStoreType = null;
    private HostnameVerifier hv = null;
    private SSLContext sslContext = null;
    private String authenticationType = null;
    String principal;
    String keytab;
    String nameRules;

    public static void main(String[] args) throws Throwable {
        PolicyMgrUserGroupBuilder ugbuilder = new PolicyMgrUserGroupBuilder();
        ugbuilder.init();
    }

    @Override
    public synchronized void init() throws Throwable {
        this.recordsToPullPerCall = this.config.getMaxRecordsPerAPICall();
        this.policyMgrBaseUrl = this.config.getPolicyManagerBaseURL();
        this.isMockRun = this.config.isMockRunEnabled();
        if (this.isMockRun) {
            LOG.setLevel(Level.DEBUG);
        }
        this.keyStoreFile = this.config.getSSLKeyStorePath();
        this.keyStoreFilepwd = this.config.getSSLKeyStorePathPassword();
        this.trustStoreFile = this.config.getSSLTrustStorePath();
        this.trustStoreFilepwd = this.config.getSSLTrustStorePathPassword();
        this.keyStoreType = KeyStore.getDefaultType();
        this.trustStoreType = KeyStore.getDefaultType();
        this.authenticationType = this.config.getProperty(AUTHENTICATION_TYPE, "simple");
        try {
            this.principal = SecureClientLogin.getPrincipal((String)this.config.getProperty(PRINCIPAL, ""), (String)LOCAL_HOSTNAME);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.keytab = this.config.getProperty(KEYTAB, "");
        this.nameRules = this.config.getProperty(NAME_RULE, "DEFAULT");
        this.buildUserGroupInfo();
    }

    private void buildUserGroupInfo() throws Throwable {
        if (this.authenticationType != null && this.AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab) && LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> Kerberos Environment : Principal is " + this.principal + " and Keytab is " + this.keytab));
        }
        if (this.authenticationType != null && this.AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                LOG.info((Object)("Using principal = " + this.principal + " and keytab = " + this.keytab));
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                Subject.doAs(sub, new PrivilegedAction<Void>(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public Void run() {
                        try {
                            PolicyMgrUserGroupBuilder.this.buildGroupList();
                            PolicyMgrUserGroupBuilder.this.buildUserList();
                            PolicyMgrUserGroupBuilder.this.buildUserGroupLinkList();
                            PolicyMgrUserGroupBuilder.this.rebuildUserGroupMap();
                            if (!LOG.isDebugEnabled()) return null;
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Failed to build Group List : ", (Throwable)e);
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to Authenticate Using given Principal and Keytab : ", (Throwable)e);
            }
        } else {
            this.buildGroupList();
            this.buildUserList();
            this.buildUserGroupLinkList();
            this.rebuildUserGroupMap();
            if (LOG.isDebugEnabled()) {
                this.print();
            }
        }
    }

    private String getURL(String uri) {
        String ret = null;
        ret = this.policyMgrBaseUrl + (uri.startsWith("/") ? uri : "/" + uri);
        return ret;
    }

    private void rebuildUserGroupMap() {
        for (XUserInfo user : this.xuserList) {
            this.addUserToList(user);
        }
        for (XGroupInfo group : this.xgroupList) {
            this.addGroupToList(group);
        }
        for (XUserGroupInfo ug : this.xusergroupList) {
            this.addUserGroupToList(ug);
        }
    }

    private void addUserToList(XUserInfo aUserInfo) {
        String userName;
        String userId;
        if (!this.xuserList.contains(aUserInfo)) {
            this.xuserList.add(aUserInfo);
        }
        if ((userId = aUserInfo.getId()) != null) {
            this.userId2XUserInfoMap.put(userId, aUserInfo);
        }
        if ((userName = aUserInfo.getName()) != null) {
            this.userName2XUserInfoMap.put(userName, aUserInfo);
        }
    }

    private void addGroupToList(XGroupInfo aGroupInfo) {
        if (!this.xgroupList.contains(aGroupInfo)) {
            this.xgroupList.add(aGroupInfo);
        }
        if (aGroupInfo.getName() != null) {
            this.groupName2XGroupInfoMap.put(aGroupInfo.getName(), aGroupInfo);
        }
    }

    private void addUserGroupToList(XUserGroupInfo ugInfo) {
        List<String> groups;
        XUserInfo user;
        String userId = ugInfo.getUserId();
        if (userId != null && (user = this.userId2XUserInfoMap.get(userId)) != null && !(groups = user.getGroups()).contains(ugInfo.getGroupName())) {
            groups.add(ugInfo.getGroupName());
        }
    }

    private void addUserGroupInfoToList(XUserInfo userInfo, XGroupInfo groupInfo) {
        List<String> groups;
        XUserInfo user;
        String userId = userInfo.getId();
        if (userId != null && (user = this.userId2XUserInfoMap.get(userId)) != null && !(groups = user.getGroups()).contains(groupInfo.getName())) {
            groups.add(groupInfo.getName());
        }
    }

    private void delUserGroupFromList(XUserInfo userInfo, XGroupInfo groupInfo) {
        List<String> groups = userInfo.getGroups();
        if (groups.contains(groupInfo.getName())) {
            groups.remove(groupInfo.getName());
        }
    }

    private void print() {
        LOG.debug((Object)("Number of users read [" + this.xuserList.size() + "]"));
        for (XUserInfo user : this.xuserList) {
            LOG.debug((Object)("USER: " + user.getName()));
            for (String group : user.getGroups()) {
                LOG.debug((Object)("\tGROUP: " + group));
            }
        }
    }

    @Override
    public void addOrUpdateUser(String userName, List<String> groups) {
        UserGroupInfo ugInfo = new UserGroupInfo();
        XUserInfo user = this.userName2XUserInfoMap.get(userName);
        if (groups == null) {
            groups = new ArrayList<String>();
        }
        if (user == null) {
            LOG.debug((Object)("INFO: addPMAccount(" + userName + ")"));
            if (!this.isMockRun) {
                this.addMUser(userName);
            }
            if (!this.isMockRun) {
                this.addUserGroupInfo(userName, groups);
            }
        } else {
            List<String> oldGroups = user.getGroups();
            ArrayList<String> addGroups = new ArrayList<String>();
            ArrayList<String> delGroups = new ArrayList<String>();
            ArrayList<String> updateGroups = new ArrayList<String>();
            XGroupInfo tempXGroupInfo = null;
            for (String group : groups) {
                if (!oldGroups.contains(group)) {
                    addGroups.add(group);
                    continue;
                }
                tempXGroupInfo = this.groupName2XGroupInfoMap.get(group);
                if (tempXGroupInfo == null || GROUP_SOURCE_EXTERNAL.equals(tempXGroupInfo.getGroupSource())) continue;
                updateGroups.add(group);
            }
            for (String group : oldGroups) {
                if (groups.contains(group)) continue;
                delGroups.add(group);
            }
            for (String g : addGroups) {
                LOG.debug((Object)("INFO: addPMXAGroupToUser(" + userName + "," + g + ")"));
            }
            if (!this.isMockRun) {
                if (!addGroups.isEmpty()) {
                    ugInfo.setXuserInfo(this.addXUserInfo(userName));
                    ugInfo.setXgroupInfo(this.getXGroupInfoList(addGroups));
                    try {
                        this.addUserGroupInfo(ugInfo);
                    }
                    catch (Throwable t) {
                        LOG.error((Object)("PolicyMgrUserGroupBuilder.addUserGroupInfo failed with exception: " + t.getMessage() + ", for user-group entry: " + ugInfo));
                    }
                }
                this.addXUserGroupInfo(user, addGroups);
            }
            for (String g : delGroups) {
                LOG.debug((Object)("INFO: delPMXAGroupFromUser(" + userName + "," + g + ")"));
            }
            if (!this.isMockRun) {
                this.delXUserGroupInfo(user, delGroups);
            }
            if (!this.isMockRun && !updateGroups.isEmpty()) {
                ugInfo.setXuserInfo(this.addXUserInfo(userName));
                ugInfo.setXgroupInfo(this.getXGroupInfoList(updateGroups));
                try {
                    this.addUserGroupInfo(ugInfo);
                }
                catch (Throwable t) {
                    LOG.error((Object)("PolicyMgrUserGroupBuilder.addUserGroupInfo failed with exception: " + t.getMessage() + ", for user-group entry: " + ugInfo));
                }
            }
        }
    }

    private void buildGroupList() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.buildGroupList");
        }
        Client c = this.getClient();
        int totalCount = 100;
        int retrievedCount = 0;
        while (retrievedCount < totalCount) {
            WebResource r = c.resource(this.getURL("/service/xusers/groups/")).queryParam("pageSize", this.recordsToPullPerCall).queryParam("startIndex", String.valueOf(retrievedCount));
            String response = (String)r.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(String.class);
            LOG.debug((Object)("RESPONSE: [" + response + "]"));
            Gson gson = new GsonBuilder().create();
            GetXGroupListResponse groupList = (GetXGroupListResponse)gson.fromJson(response, GetXGroupListResponse.class);
            totalCount = groupList.getTotalCount();
            if (groupList.getXgroupInfoList() == null) continue;
            this.xgroupList.addAll(groupList.getXgroupInfoList());
            retrievedCount = this.xgroupList.size();
            for (XGroupInfo g : groupList.getXgroupInfoList()) {
                LOG.debug((Object)("GROUP:  Id:" + g.getId() + ", Name: " + g.getName() + ", Description: " + g.getDescription()));
            }
        }
    }

    private void buildUserList() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.buildUserList");
        }
        Client c = this.getClient();
        int totalCount = 100;
        int retrievedCount = 0;
        while (retrievedCount < totalCount) {
            WebResource r = c.resource(this.getURL("/service/xusers/users/")).queryParam("pageSize", this.recordsToPullPerCall).queryParam("startIndex", String.valueOf(retrievedCount));
            String response = (String)r.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(String.class);
            Gson gson = new GsonBuilder().create();
            LOG.debug((Object)("RESPONSE: [" + response + "]"));
            GetXUserListResponse userList = (GetXUserListResponse)gson.fromJson(response, GetXUserListResponse.class);
            totalCount = userList.getTotalCount();
            if (userList.getXuserInfoList() == null) continue;
            this.xuserList.addAll(userList.getXuserInfoList());
            retrievedCount = this.xuserList.size();
            for (XUserInfo u : userList.getXuserInfoList()) {
                LOG.debug((Object)("USER: Id:" + u.getId() + ", Name: " + u.getName() + ", Description: " + u.getDescription()));
            }
        }
    }

    private void buildUserGroupLinkList() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.buildUserGroupLinkList");
        }
        Client c = this.getClient();
        int totalCount = 100;
        int retrievedCount = 0;
        while (retrievedCount < totalCount) {
            WebResource r = c.resource(this.getURL("/service/xusers/groupusers/")).queryParam("pageSize", this.recordsToPullPerCall).queryParam("startIndex", String.valueOf(retrievedCount));
            String response = (String)r.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(String.class);
            LOG.debug((Object)("RESPONSE: [" + response + "]"));
            Gson gson = new GsonBuilder().create();
            GetXUserGroupListResponse usergroupList = (GetXUserGroupListResponse)gson.fromJson(response, GetXUserGroupListResponse.class);
            totalCount = usergroupList.getTotalCount();
            if (usergroupList.getXusergroupInfoList() == null) continue;
            this.xusergroupList.addAll(usergroupList.getXusergroupInfoList());
            retrievedCount = this.xusergroupList.size();
            for (XUserGroupInfo ug : usergroupList.getXusergroupInfoList()) {
                LOG.debug((Object)("USER_GROUP: UserId:" + ug.getUserId() + ", Name: " + ug.getGroupName()));
            }
        }
    }

    private UserGroupInfo addUserGroupInfo(String userName, List<String> groups) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyMgrUserGroupBuilder.addUserGroupInfo " + userName + " and groups"));
        }
        UserGroupInfo ret = null;
        XUserInfo user = null;
        LOG.debug((Object)("INFO: addPMXAUser(" + userName + ")"));
        if (!this.isMockRun) {
            user = this.addXUserInfo(userName);
        }
        for (String g : groups) {
            LOG.debug((Object)("INFO: addPMXAGroupToUser(" + userName + "," + g + ")"));
        }
        if (!this.isMockRun) {
            this.addXUserGroupInfo(user, groups);
        }
        if (this.authenticationType != null && this.AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                final UserGroupInfo result = ret;
                ret = Subject.doAs(sub, new PrivilegedAction<UserGroupInfo>(){

                    @Override
                    public UserGroupInfo run() {
                        try {
                            return PolicyMgrUserGroupBuilder.this.getUsergroupInfo(result);
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Failed to add User Group Info : ", (Throwable)e);
                            return null;
                        }
                    }
                });
                return ret;
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to Authenticate Using given Principal and Keytab : ", (Throwable)e);
                return null;
            }
        }
        return this.getUsergroupInfo(ret);
    }

    private UserGroupInfo getUsergroupInfo(UserGroupInfo ret) {
        Client c = this.getClient();
        WebResource r = c.resource(this.getURL(PM_ADD_USER_GROUP_INFO_URI));
        Gson gson = new GsonBuilder().create();
        String jsonString = gson.toJson((Object)this.usergroupInfo);
        LOG.debug((Object)("USER GROUP MAPPING" + jsonString));
        String response = (String)((WebResource.Builder)r.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).post(String.class, (Object)jsonString);
        LOG.debug((Object)("RESPONSE: [" + response + "]"));
        ret = (UserGroupInfo)gson.fromJson(response, UserGroupInfo.class);
        if (ret != null) {
            XUserInfo xUserInfo = ret.getXuserInfo();
            this.addUserToList(xUserInfo);
            for (XGroupInfo xGroupInfo : ret.getXgroupInfo()) {
                this.addGroupToList(xGroupInfo);
                this.addUserGroupInfoToList(xUserInfo, xGroupInfo);
            }
        }
        return ret;
    }

    private void getUserGroupInfo(UserGroupInfo ret, UserGroupInfo usergroupInfo) {
        Client c = this.getClient();
        WebResource r = c.resource(this.getURL(PM_ADD_USER_GROUP_INFO_URI));
        Gson gson = new GsonBuilder().create();
        String jsonString = gson.toJson((Object)usergroupInfo);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("USER GROUP MAPPING" + jsonString));
        }
        String response = null;
        try {
            response = (String)((WebResource.Builder)r.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).post(String.class, (Object)jsonString);
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed to communicate Ranger Admin : ", t);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RESPONSE: [" + response + "]"));
        }
        if ((ret = (UserGroupInfo)gson.fromJson(response, UserGroupInfo.class)) != null) {
            XUserInfo xUserInfo = ret.getXuserInfo();
            this.addUserToList(xUserInfo);
            for (XGroupInfo xGroupInfo : ret.getXgroupInfo()) {
                this.addGroupToList(xGroupInfo);
                this.addUserGroupInfoToList(xUserInfo, xGroupInfo);
            }
        }
    }

    private void addUserGroupInfo(UserGroupInfo usergroupInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.addUserGroupInfo");
        }
        UserGroupInfo ret = null;
        if (this.authenticationType != null && this.AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                final UserGroupInfo result = ret;
                final UserGroupInfo ugInfo = usergroupInfo;
                Subject.doAs(sub, new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        try {
                            PolicyMgrUserGroupBuilder.this.getUserGroupInfo(result, ugInfo);
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Failed to add User Group Info : ", (Throwable)e);
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to Authenticate Using given Principal and Keytab : ", (Throwable)e);
            }
        } else {
            try {
                this.getUserGroupInfo(ret, usergroupInfo);
            }
            catch (Throwable t) {
                LOG.error((Object)"Failed to add User Group Info : ", t);
            }
        }
    }

    private XUserInfo addXUserInfo(String aUserName) {
        XUserInfo xuserInfo = new XUserInfo();
        xuserInfo.setName(aUserName);
        xuserInfo.setDescription(aUserName + " - add from Unix box");
        this.usergroupInfo.setXuserInfo(xuserInfo);
        return xuserInfo;
    }

    private XGroupInfo addXGroupInfo(String aGroupName) {
        XGroupInfo addGroup = new XGroupInfo();
        addGroup.setName(aGroupName);
        addGroup.setDescription(aGroupName + " - add from Unix box");
        addGroup.setGroupType(GROUP_SOURCE_EXTERNAL);
        addGroup.setGroupSource(GROUP_SOURCE_EXTERNAL);
        return addGroup;
    }

    private void addXUserGroupInfo(XUserInfo aUserInfo, List<String> aGroupList) {
        ArrayList<XGroupInfo> xGroupInfoList = new ArrayList<XGroupInfo>();
        for (String groupName : aGroupList) {
            XGroupInfo group = this.groupName2XGroupInfoMap.get(groupName);
            if (group == null) {
                group = this.addXGroupInfo(groupName);
            }
            xGroupInfoList.add(group);
            this.addXUserGroupInfo(aUserInfo, group);
        }
        this.usergroupInfo.setXgroupInfo(xGroupInfoList);
    }

    private List<XGroupInfo> getXGroupInfoList(List<String> aGroupList) {
        ArrayList<XGroupInfo> xGroupInfoList = new ArrayList<XGroupInfo>();
        for (String groupName : aGroupList) {
            XGroupInfo group = this.groupName2XGroupInfoMap.get(groupName);
            if (group == null) {
                group = this.addXGroupInfo(groupName);
            } else if (!GROUP_SOURCE_EXTERNAL.equals(group.getGroupSource())) {
                group.setGroupSource(GROUP_SOURCE_EXTERNAL);
            }
            xGroupInfoList.add(group);
        }
        return xGroupInfoList;
    }

    private XUserGroupInfo addXUserGroupInfo(XUserInfo aUserInfo, XGroupInfo aGroupInfo) {
        XUserGroupInfo ugInfo = new XUserGroupInfo();
        ugInfo.setUserId(aUserInfo.getId());
        ugInfo.setGroupName(aGroupInfo.getName());
        return ugInfo;
    }

    private void delXUserGroupInfo(final XUserInfo aUserInfo, List<String> aGroupList) {
        for (String groupName : aGroupList) {
            final XGroupInfo group = this.groupName2XGroupInfoMap.get(groupName);
            if (group == null) continue;
            if (this.authenticationType != null && this.AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
                try {
                    LOG.info((Object)("Using principal = " + this.principal + " and keytab = " + this.keytab));
                    Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                    Subject.doAs(sub, new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            try {
                                PolicyMgrUserGroupBuilder.this.delXUserGroupInfo(aUserInfo, group);
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Failed to build Group List : ", (Throwable)e);
                            }
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    LOG.error((Object)"Failed to Authenticate Using given Principal and Keytab : ", (Throwable)e);
                }
                continue;
            }
            this.delXUserGroupInfo(aUserInfo, group);
        }
    }

    private void delXUserGroupInfo(XUserInfo aUserInfo, XGroupInfo aGroupInfo) {
        String groupName = aGroupInfo.getName();
        String userName = aUserInfo.getName();
        try {
            Client c = this.getClient();
            String uri = PM_DEL_USER_GROUP_LINK_URI.replaceAll(Pattern.quote("${groupName}"), UserSyncUtil.encodeURIParam(groupName)).replaceAll(Pattern.quote("${userName}"), UserSyncUtil.encodeURIParam(userName));
            WebResource r = c.resource(this.getURL(uri));
            ClientResponse response = (ClientResponse)r.delete(ClientResponse.class);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RESPONSE: [" + response.toString() + "]"));
            }
            if (response.getStatus() == 200) {
                this.delUserGroupFromList(aUserInfo, aGroupInfo);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("ERROR: Unable to delete GROUP: " + groupName + " from USER:" + userName), (Throwable)e);
        }
    }

    private MUserInfo addMUser(String aUserName) {
        MUserInfo ret = null;
        MUserInfo userInfo = new MUserInfo();
        userInfo.setLoginId(aUserName);
        userInfo.setFirstName(aUserName);
        userInfo.setLastName(aUserName);
        if (this.authenticationType != null && this.AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                final MUserInfo result = ret;
                final MUserInfo userInfoFinal = userInfo;
                ret = Subject.doAs(sub, new PrivilegedAction<MUserInfo>(){

                    @Override
                    public MUserInfo run() {
                        try {
                            return PolicyMgrUserGroupBuilder.this.getMUser(userInfoFinal, result);
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Failed to add User : ", (Throwable)e);
                            return null;
                        }
                    }
                });
                return ret;
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to Authenticate Using given Principal and Keytab : ", (Throwable)e);
                return null;
            }
        }
        return this.getMUser(userInfo, ret);
    }

    private MUserInfo getMUser(MUserInfo userInfo, MUserInfo ret) {
        Client c = this.getClient();
        WebResource r = c.resource(this.getURL(PM_ADD_LOGIN_USER_URI));
        Gson gson = new GsonBuilder().create();
        String jsonString = gson.toJson((Object)userInfo);
        String response = (String)((WebResource.Builder)r.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).post(String.class, (Object)jsonString);
        LOG.debug((Object)("RESPONSE[" + response + "]"));
        ret = (MUserInfo)gson.fromJson(response, MUserInfo.class);
        LOG.debug((Object)("MUser Creation successful " + ret));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Client getClient() {
        Client ret = null;
        if (this.policyMgrBaseUrl.startsWith("https://")) {
            DefaultClientConfig config = new DefaultClientConfig();
            if (this.sslContext == null) {
                try {
                    KeyManagerFactory keyManagerFactory;
                    InputStream in;
                    KeyManager[] kmList = null;
                    TrustManager[] tmList = null;
                    if (this.keyStoreFile != null && this.keyStoreFilepwd != null) {
                        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
                        in = null;
                        try {
                            in = this.getFileInputStream(this.keyStoreFile);
                            if (in == null) {
                                LOG.error((Object)("Unable to obtain keystore from file [" + this.keyStoreFile + "]"));
                                Client client = ret;
                                return client;
                            }
                            keyStore.load(in, this.keyStoreFilepwd.toCharArray());
                            keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                            keyManagerFactory.init(keyStore, this.keyStoreFilepwd.toCharArray());
                            kmList = keyManagerFactory.getKeyManagers();
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    if (this.trustStoreFile != null && this.trustStoreFilepwd != null) {
                        KeyStore trustStore = KeyStore.getInstance(this.trustStoreType);
                        in = null;
                        try {
                            in = this.getFileInputStream(this.trustStoreFile);
                            if (in == null) {
                                LOG.error((Object)("Unable to obtain keystore from file [" + this.trustStoreFile + "]"));
                                keyManagerFactory = ret;
                                return keyManagerFactory;
                            }
                            trustStore.load(in, this.trustStoreFilepwd.toCharArray());
                            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                            trustManagerFactory.init(trustStore);
                            tmList = trustManagerFactory.getTrustManagers();
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    this.sslContext = SSLContext.getInstance("SSL");
                    this.sslContext.init(kmList, tmList, new SecureRandom());
                    this.hv = new HostnameVerifier(){

                        @Override
                        public boolean verify(String urlHostName, SSLSession session) {
                            return session.getPeerHost().equals(urlHostName);
                        }
                    };
                }
                catch (Throwable t) {
                    throw new RuntimeException("Unable to create SSLConext for communication to policy manager", t);
                }
            }
            config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(this.hv, this.sslContext));
            ret = Client.create((ClientConfig)config);
        } else {
            DefaultClientConfig cc = new DefaultClientConfig();
            cc.getProperties().put("com.sun.jersey.client.property.followRedirects", true);
            ret = Client.create((ClientConfig)cc);
        }
        if (this.authenticationType != null && this.AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType)) {
            if (SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) return ret;
        }
        if (ret == null) return ret;
        String username = this.config.getPolicyMgrUserName();
        String password = this.config.getPolicyMgrPassword();
        if (username == null || password == null || username.trim().isEmpty() || password.trim().isEmpty()) {
            username = this.config.getDefaultPolicyMgrUserName();
            password = this.config.getDefaultPolicyMgrPassword();
        }
        if (username == null) return ret;
        if (password == null) return ret;
        ret.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, password));
        return ret;
    }

    private InputStream getFileInputStream(String path) throws FileNotFoundException {
        InputStream ret = null;
        File f = new File(path);
        if (f.exists()) {
            ret = new FileInputStream(f);
        } else {
            ret = PolicyMgrUserGroupBuilder.class.getResourceAsStream(path);
            if (ret == null && !path.startsWith("/")) {
                ret = this.getClass().getResourceAsStream("/" + path);
            }
            if (ret == null && (ret = ClassLoader.getSystemClassLoader().getResourceAsStream(path)) == null && !path.startsWith("/")) {
                ret = ClassLoader.getSystemResourceAsStream("/" + path);
            }
        }
        return ret;
    }

    @Override
    public void addOrUpdateGroup(String groupName) {
        XGroupInfo group = this.groupName2XGroupInfoMap.get(groupName);
        if (group == null && !this.isMockRun && (group = this.addGroupInfo(groupName)) != null) {
            this.addGroupToList(group);
        }
    }

    private XGroupInfo addGroupInfo(String groupName) {
        XGroupInfo ret = null;
        XGroupInfo group = null;
        LOG.debug((Object)("INFO: addPMXAGroup(" + groupName + ")"));
        if (!this.isMockRun) {
            group = this.addXGroupInfo(groupName);
        }
        if (this.authenticationType != null && this.AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                LOG.info((Object)("Using principal = " + this.principal + " and keytab = " + this.keytab));
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                final XGroupInfo groupInfo = group;
                ret = Subject.doAs(sub, new PrivilegedAction<XGroupInfo>(){

                    @Override
                    public XGroupInfo run() {
                        try {
                            return PolicyMgrUserGroupBuilder.this.getAddedGroupInfo(groupInfo);
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Failed to build Group List : ", (Throwable)e);
                            return null;
                        }
                    }
                });
                return ret;
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to Authenticate Using given Principal and Keytab : ", (Throwable)e);
                return null;
            }
        }
        return this.getAddedGroupInfo(group);
    }

    private XGroupInfo getAddedGroupInfo(XGroupInfo group) {
        XGroupInfo ret = null;
        Client c = this.getClient();
        WebResource r = c.resource(this.getURL("/service/xusers/groups/"));
        Gson gson = new GsonBuilder().create();
        String jsonString = gson.toJson((Object)group);
        LOG.debug((Object)("Group" + jsonString));
        String response = (String)((WebResource.Builder)r.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).post(String.class, (Object)jsonString);
        LOG.debug((Object)("RESPONSE: [" + response + "]"));
        ret = (XGroupInfo)gson.fromJson(response, XGroupInfo.class);
        return ret;
    }

    static {
        try {
            LOCAL_HOSTNAME = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            LOCAL_HOSTNAME = "unknown";
        }
    }
}

