/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.usergroupsync;

import org.apache.log4j.Logger;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.apache.ranger.usergroupsync.Mapper;
import org.apache.ranger.usergroupsync.UserGroupSource;

public abstract class AbstractUserGroupSource
implements UserGroupSource {
    private static final Logger LOG = Logger.getLogger(AbstractUserGroupSource.class);
    protected UserGroupSyncConfig config = UserGroupSyncConfig.getInstance();
    protected Mapper userNameRegExInst = null;
    protected Mapper groupNameRegExInst = null;

    public AbstractUserGroupSource() {
        String mappingUserNameHandler = this.config.getUserSyncMappingUserNameHandler();
        try {
            if (mappingUserNameHandler != null) {
                Class<?> regExClass = Class.forName(mappingUserNameHandler);
                this.userNameRegExInst = (Mapper)regExClass.newInstance();
                if (this.userNameRegExInst != null) {
                    this.userNameRegExInst.init("ranger.usersync.mapping.username.regex");
                } else {
                    LOG.error((Object)"RegEx handler instance for username is null!");
                }
            }
        }
        catch (ClassNotFoundException cne) {
            LOG.error((Object)("Failed to load " + mappingUserNameHandler + " " + cne));
        }
        catch (Throwable te) {
            LOG.error((Object)("Failed to instantiate " + mappingUserNameHandler + " " + te));
        }
        String mappingGroupNameHandler = this.config.getUserSyncMappingGroupNameHandler();
        try {
            if (mappingGroupNameHandler != null) {
                Class<?> regExClass = Class.forName(mappingGroupNameHandler);
                this.groupNameRegExInst = (Mapper)regExClass.newInstance();
                if (this.groupNameRegExInst != null) {
                    this.groupNameRegExInst.init("ranger.usersync.mapping.groupname.regex");
                } else {
                    LOG.error((Object)"RegEx handler instance for groupname is null!");
                }
            }
        }
        catch (ClassNotFoundException cne) {
            LOG.error((Object)("Failed to load " + mappingGroupNameHandler + " " + cne));
        }
        catch (Throwable te) {
            LOG.error((Object)("Failed to instantiate " + mappingGroupNameHandler + " " + te));
        }
    }
}

