/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.example;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.application.StreamApplication;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.config.Config;
import org.apache.samza.example.models.AdClickEvent;
import org.apache.samza.example.models.EnrichedAdClickEvent;
import org.apache.samza.example.models.Member;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.OutputStream;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.runtime.ApplicationRunner;
import org.apache.samza.runtime.ApplicationRunners;
import org.apache.samza.serializers.JsonSerdeV2;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.serializers.StringSerde;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.system.descriptors.OutputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaInputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaOutputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaSystemDescriptor;
import org.apache.samza.util.CommandLine;

public class AsyncApplicationExample
implements StreamApplication {
    public void describe(StreamApplicationDescriptor appDescriptor) {
        KafkaSystemDescriptor trackingSystem = new KafkaSystemDescriptor("tracking");
        KafkaInputDescriptor inputStreamDescriptor = trackingSystem.getInputDescriptor("adClickEvent", (Serde)new JsonSerdeV2(AdClickEvent.class));
        KafkaOutputDescriptor outputStreamDescriptor = trackingSystem.getOutputDescriptor("enrichedAdClickEvent", (Serde)KVSerde.of((Serde)new StringSerde(), (Serde)new JsonSerdeV2(EnrichedAdClickEvent.class)));
        MessageStream adClickEventStream = appDescriptor.getInputStream((InputDescriptor)inputStreamDescriptor);
        OutputStream enrichedAdClickStream = appDescriptor.getOutputStream((OutputDescriptor)outputStreamDescriptor);
        adClickEventStream.flatMapAsync(AsyncApplicationExample::enrichAdClickEvent).map((MapFunction & Serializable)enrichedAdClickEvent -> KV.of((Object)enrichedAdClickEvent.getCountry(), (Object)enrichedAdClickEvent)).sendTo(enrichedAdClickStream);
    }

    public static void main(String[] args) {
        CommandLine cmdLine = new CommandLine();
        Config config = cmdLine.loadConfig(cmdLine.parser().parse(args));
        ApplicationRunner runner = ApplicationRunners.getApplicationRunner((SamzaApplication)new AsyncApplicationExample(), (Config)config);
        runner.run();
        runner.waitForFinish();
    }

    private static CompletionStage<Collection<EnrichedAdClickEvent>> enrichAdClickEvent(AdClickEvent adClickEvent) {
        CompletionStage<Member> decoratedMemberFuture = MemberDecoratorService.decorateMember(adClickEvent.getMemberId());
        return decoratedMemberFuture.thenApply(member -> Collections.singleton(new EnrichedAdClickEvent(adClickEvent.getId(), member.getGender(), member.getCountry())));
    }

    private static class MemberDecoratorService {
        private static final String[] GENDER = new String[]{"F", "M", "U"};
        private static final List<String> COUNTRY = ImmutableList.of((Object)"KENYA", (Object)"NEW ZEALAND", (Object)"INDONESIA", (Object)"PERU", (Object)"FRANCE", (Object)"MEXICO");
        private static final Random RANDOM = new Random();

        private MemberDecoratorService() {
        }

        static CompletionStage<Member> decorateMember(int memberId) {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    Thread.sleep((long)(Math.random() * 10000.0));
                }
                catch (InterruptedException ec) {
                    System.out.println("Interrupted during sleep");
                }
                return new Member(memberId, MemberDecoratorService.getRandomGender(), MemberDecoratorService.getRandomCountry());
            });
        }

        static String getRandomGender() {
            int index = RANDOM.nextInt(GENDER.length);
            return GENDER[index];
        }

        static String getRandomCountry() {
            int index = RANDOM.nextInt(COUNTRY.size());
            return COUNTRY.get(index);
        }
    }
}

