/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.example;

import java.io.Serializable;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.application.StreamApplication;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.config.Config;
import org.apache.samza.example.models.PageViewEvent;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.functions.FilterFunction;
import org.apache.samza.runtime.ApplicationRunner;
import org.apache.samza.runtime.ApplicationRunners;
import org.apache.samza.serializers.JsonSerdeV2;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.serializers.StringSerde;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.system.descriptors.OutputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaInputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaOutputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaSystemDescriptor;
import org.apache.samza.util.CommandLine;

public class BroadcastExample
implements StreamApplication {
    public static void main(String[] args) {
        CommandLine cmdLine = new CommandLine();
        Config config = cmdLine.loadConfig(cmdLine.parser().parse(args));
        ApplicationRunner runner = ApplicationRunners.getApplicationRunner((SamzaApplication)new BroadcastExample(), (Config)config);
        runner.run();
        runner.waitForFinish();
    }

    public void describe(StreamApplicationDescriptor appDescriptor) {
        KVSerde serde = KVSerde.of((Serde)new StringSerde("UTF-8"), (Serde)new JsonSerdeV2(PageViewEvent.class));
        KafkaSystemDescriptor trackingSystem = new KafkaSystemDescriptor("tracking");
        KafkaInputDescriptor pageViewEvent = trackingSystem.getInputDescriptor("pageViewEvent", (Serde)serde);
        KafkaOutputDescriptor outStream1 = trackingSystem.getOutputDescriptor("outStream1", (Serde)serde);
        KafkaOutputDescriptor outStream2 = trackingSystem.getOutputDescriptor("outStream2", (Serde)serde);
        KafkaOutputDescriptor outStream3 = trackingSystem.getOutputDescriptor("outStream3", (Serde)serde);
        MessageStream inputStream = appDescriptor.getInputStream((InputDescriptor)pageViewEvent);
        inputStream.filter((FilterFunction & Serializable)m -> ((String)m.key).equals("key1")).sendTo(appDescriptor.getOutputStream((OutputDescriptor)outStream1));
        inputStream.filter((FilterFunction & Serializable)m -> ((String)m.key).equals("key2")).sendTo(appDescriptor.getOutputStream((OutputDescriptor)outStream2));
        inputStream.filter((FilterFunction & Serializable)m -> ((String)m.key).equals("key3")).sendTo(appDescriptor.getOutputStream((OutputDescriptor)outStream3));
    }
}

