/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.example;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.application.StreamApplication;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.config.Config;
import org.apache.samza.context.Context;
import org.apache.samza.example.models.PageViewEvent;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.OutputStream;
import org.apache.samza.operators.functions.FlatMapFunction;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.runtime.ApplicationRunner;
import org.apache.samza.runtime.ApplicationRunners;
import org.apache.samza.serializers.JsonSerdeV2;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.serializers.StringSerde;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.system.descriptors.OutputDescriptor;
import org.apache.samza.system.descriptors.SystemDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaInputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaOutputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaSystemDescriptor;
import org.apache.samza.util.CommandLine;

public class KeyValueStoreExample
implements StreamApplication {
    public static void main(String[] args) {
        CommandLine cmdLine = new CommandLine();
        Config config = cmdLine.loadConfig(cmdLine.parser().parse(args));
        ApplicationRunner runner = ApplicationRunners.getApplicationRunner((SamzaApplication)new KeyValueStoreExample(), (Config)config);
        runner.run();
        runner.waitForFinish();
    }

    public void describe(StreamApplicationDescriptor appDescriptor) {
        KafkaSystemDescriptor trackingSystem = new KafkaSystemDescriptor("tracking");
        KafkaInputDescriptor inputStreamDescriptor = trackingSystem.getInputDescriptor("pageViewEvent", (Serde)new JsonSerdeV2(PageViewEvent.class));
        KafkaOutputDescriptor outputStreamDescriptor = trackingSystem.getOutputDescriptor("pageViewEventPerMember", (Serde)KVSerde.of((Serde)new StringSerde(), (Serde)new JsonSerdeV2(StatsOutput.class)));
        appDescriptor.withDefaultSystem((SystemDescriptor)trackingSystem);
        MessageStream pageViewEvents = appDescriptor.getInputStream((InputDescriptor)inputStreamDescriptor);
        OutputStream pageViewEventPerMember = appDescriptor.getOutputStream((OutputDescriptor)outputStreamDescriptor);
        pageViewEvents.partitionBy((MapFunction & Serializable)pve -> pve.getMemberId(), (MapFunction & Serializable)pve -> pve, KVSerde.of((Serde)new StringSerde(), (Serde)new JsonSerdeV2(PageViewEvent.class)), "partitionBy").map(KV::getValue).flatMap((FlatMapFunction)new MyStatsCounter()).map((MapFunction & Serializable)stats -> KV.of((Object)((StatsOutput)stats).memberId, (Object)stats)).sendTo(pageViewEventPerMember);
    }

    static class StatsOutput {
        private String memberId;
        private long timestamp;
        private Integer count;

        StatsOutput(String key, long timestamp, Integer count) {
            this.memberId = key;
            this.timestamp = timestamp;
            this.count = count;
        }
    }

    static class MyStatsCounter
    implements FlatMapFunction<PageViewEvent, StatsOutput> {
        private final int timeoutMs = 600000;
        KeyValueStore<String, StatsWindowState> statsStore;

        MyStatsCounter() {
        }

        public Collection<StatsOutput> apply(PageViewEvent message) {
            ArrayList<StatsOutput> outputStats = new ArrayList<StatsOutput>();
            long wndTimestamp = (long)Math.floor(TimeUnit.MILLISECONDS.toMinutes(message.getTimestamp()) / 5L) * 5L;
            String wndKey = String.format("%s-%d", message.getMemberId(), wndTimestamp);
            StatsWindowState curState = (StatsWindowState)this.statsStore.get((Object)wndKey);
            if (curState == null) {
                curState = new StatsWindowState();
            }
            ++curState.newCount;
            long curTimeMs = System.currentTimeMillis();
            if (curState.newCount > 0 && curState.timeAtLastOutput + 600000L < curTimeMs) {
                curState.timeAtLastOutput = curTimeMs;
                curState.lastCount += curState.newCount;
                curState.newCount = 0;
                outputStats.add(new StatsOutput(message.getMemberId(), wndTimestamp, curState.lastCount));
            }
            this.statsStore.put((Object)wndKey, (Object)curState);
            return outputStats;
        }

        public void init(Context context) {
            this.statsStore = context.getTaskContext().getStore("my-stats-wnd-store");
        }

        class StatsWindowState {
            int lastCount = 0;
            long timeAtLastOutput = 0L;
            int newCount = 0;

            StatsWindowState() {
            }
        }
    }
}

