/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.example;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.application.StreamApplication;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.config.Config;
import org.apache.samza.example.models.PageViewEvent;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.runtime.ApplicationRunner;
import org.apache.samza.runtime.ApplicationRunners;
import org.apache.samza.serializers.JsonSerdeV2;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.serializers.StringSerde;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.system.descriptors.OutputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaInputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaOutputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaSystemDescriptor;
import org.apache.samza.util.CommandLine;

public class MergeExample
implements StreamApplication {
    public static void main(String[] args) {
        CommandLine cmdLine = new CommandLine();
        Config config = cmdLine.loadConfig(cmdLine.parser().parse(args));
        ApplicationRunner runner = ApplicationRunners.getApplicationRunner((SamzaApplication)new MergeExample(), (Config)config);
        runner.run();
        runner.waitForFinish();
    }

    public void describe(StreamApplicationDescriptor appDescriptor) {
        KVSerde serde = KVSerde.of((Serde)new StringSerde("UTF-8"), (Serde)new JsonSerdeV2(PageViewEvent.class));
        KafkaSystemDescriptor trackingSystem = new KafkaSystemDescriptor("tracking");
        KafkaInputDescriptor isd1 = trackingSystem.getInputDescriptor("pageViewStream1", (Serde)serde);
        KafkaInputDescriptor isd2 = trackingSystem.getInputDescriptor("pageViewStream2", (Serde)serde);
        KafkaInputDescriptor isd3 = trackingSystem.getInputDescriptor("pageViewStream3", (Serde)serde);
        KafkaOutputDescriptor osd = trackingSystem.getOutputDescriptor("mergedStream", (Serde)serde);
        MessageStream.mergeAll((Collection)ImmutableList.of((Object)appDescriptor.getInputStream((InputDescriptor)isd1), (Object)appDescriptor.getInputStream((InputDescriptor)isd2), (Object)appDescriptor.getInputStream((InputDescriptor)isd3))).sendTo(appDescriptor.getOutputStream((OutputDescriptor)osd));
    }
}

