/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.example;

import java.io.Serializable;
import java.time.Duration;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.application.StreamApplication;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.config.Config;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.functions.JoinFunction;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.runtime.ApplicationRunner;
import org.apache.samza.runtime.ApplicationRunners;
import org.apache.samza.serializers.JsonSerdeV2;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.serializers.StringSerde;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.system.descriptors.OutputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaInputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaOutputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaSystemDescriptor;
import org.apache.samza.util.CommandLine;

public class OrderShipmentJoinExample
implements StreamApplication {
    public static void main(String[] args) throws Exception {
        CommandLine cmdLine = new CommandLine();
        Config config = cmdLine.loadConfig(cmdLine.parser().parse(args));
        ApplicationRunner runner = ApplicationRunners.getApplicationRunner((SamzaApplication)new OrderShipmentJoinExample(), (Config)config);
        runner.run();
        runner.waitForFinish();
    }

    public void describe(StreamApplicationDescriptor appDescriptor) {
        KafkaSystemDescriptor trackingSystem = new KafkaSystemDescriptor("tracking");
        KafkaInputDescriptor orderStreamDescriptor = trackingSystem.getInputDescriptor("orders", (Serde)new JsonSerdeV2(OrderRecord.class));
        KafkaInputDescriptor shipmentStreamDescriptor = trackingSystem.getInputDescriptor("shipments", (Serde)new JsonSerdeV2(ShipmentRecord.class));
        KafkaOutputDescriptor fulfilledOrdersStreamDescriptor = trackingSystem.getOutputDescriptor("fulfilledOrders", (Serde)KVSerde.of((Serde)new StringSerde(), (Serde)new JsonSerdeV2(FulfilledOrderRecord.class)));
        appDescriptor.getInputStream((InputDescriptor)orderStreamDescriptor).join(appDescriptor.getInputStream((InputDescriptor)shipmentStreamDescriptor), (JoinFunction)new MyJoinFunction(), (Serde)new StringSerde(), (Serde)new JsonSerdeV2(OrderRecord.class), (Serde)new JsonSerdeV2(ShipmentRecord.class), Duration.ofMinutes(1L), "join").map((MapFunction & Serializable)fulFilledOrder -> KV.of((Object)fulFilledOrder.orderId, (Object)fulFilledOrder)).sendTo(appDescriptor.getOutputStream((OutputDescriptor)fulfilledOrdersStreamDescriptor));
    }

    static class FulfilledOrderRecord {
        String orderId;
        long orderTimeMs;
        long shipTimeMs;

        FulfilledOrderRecord(String orderId, long orderTimeMs, long shipTimeMs) {
            this.orderId = orderId;
            this.orderTimeMs = orderTimeMs;
            this.shipTimeMs = shipTimeMs;
        }
    }

    class ShipmentRecord {
        String orderId;
        long shipTimeMs;

        ShipmentRecord(String orderId, long timeMs) {
            this.orderId = orderId;
            this.shipTimeMs = timeMs;
        }
    }

    class OrderRecord {
        String orderId;
        long orderTimeMs;

        OrderRecord(String orderId, long timeMs) {
            this.orderId = orderId;
            this.orderTimeMs = timeMs;
        }
    }

    static class MyJoinFunction
    implements JoinFunction<String, OrderRecord, ShipmentRecord, FulfilledOrderRecord> {
        MyJoinFunction() {
        }

        public FulfilledOrderRecord apply(OrderRecord message, ShipmentRecord otherMessage) {
            return new FulfilledOrderRecord(message.orderId, message.orderTimeMs, otherMessage.shipTimeMs);
        }

        public String getFirstKey(OrderRecord message) {
            return message.orderId;
        }

        public String getSecondKey(ShipmentRecord message) {
            return message.orderId;
        }
    }
}

