/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.example;

import java.io.Serializable;
import java.time.Duration;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.application.StreamApplication;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.config.Config;
import org.apache.samza.example.models.PageViewCount;
import org.apache.samza.example.models.PageViewEvent;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.OutputStream;
import org.apache.samza.operators.functions.FoldLeftFunction;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.operators.functions.SupplierFunction;
import org.apache.samza.operators.triggers.Trigger;
import org.apache.samza.operators.triggers.Triggers;
import org.apache.samza.operators.windows.AccumulationMode;
import org.apache.samza.operators.windows.WindowPane;
import org.apache.samza.operators.windows.Windows;
import org.apache.samza.runtime.ApplicationRunner;
import org.apache.samza.runtime.ApplicationRunners;
import org.apache.samza.serializers.JsonSerdeV2;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.serializers.StringSerde;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.system.descriptors.OutputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaInputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaOutputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaSystemDescriptor;
import org.apache.samza.util.CommandLine;

public class PageViewCounterExample
implements StreamApplication {
    public static void main(String[] args) {
        CommandLine cmdLine = new CommandLine();
        Config config = cmdLine.loadConfig(cmdLine.parser().parse(args));
        PageViewCounterExample app = new PageViewCounterExample();
        ApplicationRunner runner = ApplicationRunners.getApplicationRunner((SamzaApplication)app, (Config)config);
        runner.run();
        runner.waitForFinish();
    }

    public void describe(StreamApplicationDescriptor appDescriptor) {
        KafkaSystemDescriptor trackingSystem = new KafkaSystemDescriptor("tracking");
        KafkaInputDescriptor inputStreamDescriptor = trackingSystem.getInputDescriptor("pageViewEvent", (Serde)new JsonSerdeV2(PageViewEvent.class));
        KafkaOutputDescriptor outputStreamDescriptor = trackingSystem.getOutputDescriptor("pageViewEventPerMember", (Serde)KVSerde.of((Serde)new StringSerde(), (Serde)new JsonSerdeV2(PageViewCount.class)));
        MessageStream pageViewEvents = appDescriptor.getInputStream((InputDescriptor)inputStreamDescriptor);
        OutputStream pageViewEventPerMemberStream = appDescriptor.getOutputStream((OutputDescriptor)outputStreamDescriptor);
        SupplierFunction & Serializable initialValue = (SupplierFunction & Serializable)() -> 0;
        FoldLeftFunction & Serializable foldLeftFn = (FoldLeftFunction & Serializable)(m, c) -> c + 1;
        pageViewEvents.window(Windows.keyedTumblingWindow(PageViewEvent::getMemberId, (Duration)Duration.ofSeconds(10L), (SupplierFunction)initialValue, (FoldLeftFunction)foldLeftFn, null, null).setEarlyTrigger(Triggers.repeat((Trigger)Triggers.count((long)5L))).setAccumulationMode(AccumulationMode.DISCARDING), "tumblingWindow").map((MapFunction & Serializable)windowPane -> KV.of((Object)windowPane.getKey().getKey(), (Object)PageViewCounterExample.buildPageViewCount((WindowPane<String, Integer>)windowPane))).sendTo(pageViewEventPerMemberStream);
    }

    static PageViewCount buildPageViewCount(WindowPane<String, Integer> windowPane) {
        String memberId = (String)windowPane.getKey().getKey();
        long timestamp = Long.valueOf(windowPane.getKey().getPaneId());
        int count = (Integer)windowPane.getMessage();
        return new PageViewCount(memberId, timestamp, count);
    }
}

