/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.example;

import java.io.Serializable;
import java.time.Duration;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.application.StreamApplication;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.config.Config;
import org.apache.samza.example.models.PageViewEvent;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.OutputStream;
import org.apache.samza.operators.functions.FoldLeftFunction;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.operators.functions.SupplierFunction;
import org.apache.samza.operators.windows.WindowPane;
import org.apache.samza.operators.windows.Windows;
import org.apache.samza.runtime.ApplicationRunner;
import org.apache.samza.runtime.ApplicationRunners;
import org.apache.samza.serializers.JsonSerdeV2;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.serializers.StringSerde;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.system.descriptors.OutputDescriptor;
import org.apache.samza.system.descriptors.SystemDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaInputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaOutputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaSystemDescriptor;
import org.apache.samza.util.CommandLine;

public class RepartitionExample
implements StreamApplication {
    public static void main(String[] args) {
        CommandLine cmdLine = new CommandLine();
        Config config = cmdLine.loadConfig(cmdLine.parser().parse(args));
        ApplicationRunner runner = ApplicationRunners.getApplicationRunner((SamzaApplication)new RepartitionExample(), (Config)config);
        runner.run();
        runner.waitForFinish();
    }

    public void describe(StreamApplicationDescriptor appDescriptor) {
        KafkaSystemDescriptor trackingSystem = new KafkaSystemDescriptor("tracking");
        KafkaInputDescriptor inputStreamDescriptor = trackingSystem.getInputDescriptor("pageViewEvent", (Serde)new JsonSerdeV2(PageViewEvent.class));
        KafkaOutputDescriptor outputStreamDescriptor = trackingSystem.getOutputDescriptor("pageViewEventPerMember", (Serde)KVSerde.of((Serde)new StringSerde(), (Serde)new JsonSerdeV2(MyStreamOutput.class)));
        appDescriptor.withDefaultSystem((SystemDescriptor)trackingSystem);
        MessageStream pageViewEvents = appDescriptor.getInputStream((InputDescriptor)inputStreamDescriptor);
        OutputStream pageViewEventPerMember = appDescriptor.getOutputStream((OutputDescriptor)outputStreamDescriptor);
        pageViewEvents.partitionBy((MapFunction & Serializable)pve -> pve.getMemberId(), (MapFunction & Serializable)pve -> pve, KVSerde.of((Serde)new StringSerde(), (Serde)new JsonSerdeV2(PageViewEvent.class)), "partitionBy").window(Windows.keyedTumblingWindow(KV::getKey, (Duration)Duration.ofMinutes(5L), (SupplierFunction & Serializable)() -> 0, (FoldLeftFunction & Serializable)(m, c) -> c + 1, null, null), "window").map((MapFunction & Serializable)windowPane -> KV.of((Object)windowPane.getKey().getKey(), (Object)new MyStreamOutput((WindowPane<String, Integer>)windowPane))).sendTo(pageViewEventPerMember);
    }

    static class MyStreamOutput {
        String memberId;
        long timestamp;
        int count;

        MyStreamOutput(WindowPane<String, Integer> m) {
            this.memberId = (String)m.getKey().getKey();
            this.timestamp = Long.valueOf(m.getKey().getPaneId());
            this.count = (Integer)m.getMessage();
        }
    }
}

