/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.example;

import java.io.Serializable;
import java.time.Duration;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.application.StreamApplication;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.config.Config;
import org.apache.samza.example.models.PageViewEvent;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.OutputStream;
import org.apache.samza.operators.functions.FoldLeftFunction;
import org.apache.samza.operators.functions.SupplierFunction;
import org.apache.samza.operators.triggers.Trigger;
import org.apache.samza.operators.triggers.Triggers;
import org.apache.samza.operators.windows.WindowPane;
import org.apache.samza.operators.windows.Windows;
import org.apache.samza.runtime.ApplicationRunner;
import org.apache.samza.runtime.ApplicationRunners;
import org.apache.samza.serializers.IntegerSerde;
import org.apache.samza.serializers.JsonSerdeV2;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.system.descriptors.OutputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaInputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaOutputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaSystemDescriptor;
import org.apache.samza.util.CommandLine;

public class WindowExample
implements StreamApplication {
    public static void main(String[] args) throws Exception {
        CommandLine cmdLine = new CommandLine();
        Config config = cmdLine.loadConfig(cmdLine.parser().parse(args));
        ApplicationRunner runner = ApplicationRunners.getApplicationRunner((SamzaApplication)new WindowExample(), (Config)config);
        runner.run();
        runner.waitForFinish();
    }

    public void describe(StreamApplicationDescriptor appDescriptor) {
        KafkaSystemDescriptor trackingSystem = new KafkaSystemDescriptor("tracking");
        KafkaInputDescriptor inputStreamDescriptor = trackingSystem.getInputDescriptor("pageViewEvent", (Serde)new JsonSerdeV2(PageViewEvent.class));
        KafkaOutputDescriptor outputStreamDescriptor = trackingSystem.getOutputDescriptor("pageViewEventPerMember", (Serde)new IntegerSerde());
        SupplierFunction & Serializable initialValue = (SupplierFunction & Serializable)() -> 0;
        FoldLeftFunction & Serializable counter = (FoldLeftFunction & Serializable)(m, c) -> c == null ? 1 : c + 1;
        MessageStream inputStream = appDescriptor.getInputStream((InputDescriptor)inputStreamDescriptor);
        OutputStream outputStream = appDescriptor.getOutputStream((OutputDescriptor)outputStreamDescriptor);
        inputStream.window(Windows.tumblingWindow((Duration)Duration.ofMinutes(10L), (SupplierFunction)initialValue, (FoldLeftFunction)counter, (Serde)new IntegerSerde()).setLateTrigger(Triggers.any((Trigger[])new Trigger[]{Triggers.count((long)30000L), Triggers.timeSinceLastMessage((Duration)Duration.ofMinutes(1L))})), "window").map(WindowPane::getMessage).sendTo(outputStream);
    }
}

