/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.mock;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.samza.Partition;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;

public class MockSystemAdmin
implements SystemAdmin {
    private final Map<Partition, SystemStreamMetadata.SystemStreamPartitionMetadata> systemStreamPartitionMetadata = new HashMap<Partition, SystemStreamMetadata.SystemStreamPartitionMetadata>();

    public MockSystemAdmin(int partitionCount) {
        for (int i = 0; i < partitionCount; ++i) {
            this.systemStreamPartitionMetadata.put(new Partition(i), new SystemStreamMetadata.SystemStreamPartitionMetadata(null, null, null));
        }
    }

    public Map<String, SystemStreamMetadata> getSystemStreamMetadata(Set<String> streamNames) {
        HashMap<String, SystemStreamMetadata> metadata = new HashMap<String, SystemStreamMetadata>();
        for (String streamName : streamNames) {
            metadata.put(streamName, new SystemStreamMetadata(streamName, this.systemStreamPartitionMetadata));
        }
        return metadata;
    }

    public Map<SystemStreamPartition, String> getOffsetsAfter(Map<SystemStreamPartition, String> offsets) {
        HashMap<SystemStreamPartition, String> offsetsAfter = new HashMap<SystemStreamPartition, String>();
        for (SystemStreamPartition systemStreamPartition : offsets.keySet()) {
            offsetsAfter.put(systemStreamPartition, null);
        }
        return offsetsAfter;
    }

    public Integer offsetComparator(String offset1, String offset2) {
        return null;
    }
}

