/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.mock;

import org.apache.samza.config.Config;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.SystemProducer;
import org.apache.samza.system.mock.MockSystemAdmin;
import org.apache.samza.system.mock.MockSystemConsumer;

public class MockSystemFactory
implements SystemFactory {
    public SystemConsumer getConsumer(String systemName, Config config, MetricsRegistry registry) {
        MockSystemConsumerConfig consumerConfig = new MockSystemConsumerConfig(systemName, config);
        return new MockSystemConsumer(consumerConfig.getMessagesPerBatch(), consumerConfig.getConsumerThreadCount(), consumerConfig.getBrokerSleepMs());
    }

    public SystemProducer getProducer(String systemName, Config config, MetricsRegistry registry) {
        throw new RuntimeException("MockSystemProducer not implemented.");
    }

    public SystemAdmin getAdmin(String systemName, Config config) {
        MockSystemConsumerConfig consumerConfig = new MockSystemConsumerConfig(systemName, config);
        return new MockSystemAdmin(consumerConfig.getPartitionsPerStream());
    }

    public static class MockSystemConsumerConfig {
        public static final int DEFAULT_PARTITION_COUNT = 4;
        public static final int DEFAULT_MESSAGES_PER_BATCH = 5000;
        public static final int DEFAULT_CONSUMER_THREAD_COUNT = 12;
        public static final int DEFAULT_BROKER_SLEEP_MS = 1;
        private final String systemName;
        private final Config config;

        public MockSystemConsumerConfig(String systemName, Config config) {
            this.systemName = systemName;
            this.config = config;
        }

        public int getPartitionsPerStream() {
            return this.config.getInt("systems." + this.systemName + ".partitions.per.stream", 4);
        }

        public int getMessagesPerBatch() {
            return this.config.getInt("systems." + this.systemName + ".messages.per.batch", 5000);
        }

        public int getConsumerThreadCount() {
            return this.config.getInt("systems." + this.systemName + ".consumer.thread.count", 12);
        }

        public int getBrokerSleepMs() {
            return this.config.getInt("systems." + this.systemName + ".broker.sleep.ms", 1);
        }
    }
}

