/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.test.framework;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.samza.test.framework.TestRunner;
import org.apache.samza.test.framework.system.descriptors.InMemoryOutputDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;

public class StreamAssert {
    public static <StreamMessageType> void containsInAnyOrder(List<StreamMessageType> expected, InMemoryOutputDescriptor<StreamMessageType> outputDescriptor, Duration timeout) throws InterruptedException {
        Preconditions.checkNotNull(outputDescriptor);
        Assert.assertThat(TestRunner.consumeStream(outputDescriptor, timeout).entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])expected.toArray()));
    }

    public static <StreamMessageType> void containsInAnyOrder(Map<Integer, List<StreamMessageType>> expected, InMemoryOutputDescriptor<StreamMessageType> outputDescriptor, Duration timeout) throws InterruptedException {
        Preconditions.checkNotNull(outputDescriptor);
        Map actual = TestRunner.consumeStream(outputDescriptor, timeout);
        for (Integer paritionId : expected.keySet()) {
            Assert.assertThat(actual.get(paritionId), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])expected.get(paritionId).toArray()));
        }
    }

    public static <StreamMessageType> void containsInOrder(List<StreamMessageType> expected, InMemoryOutputDescriptor<StreamMessageType> outputDescriptor, Duration timeout) throws InterruptedException {
        Preconditions.checkNotNull(outputDescriptor);
        Assert.assertThat(TestRunner.consumeStream(outputDescriptor, timeout).entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList()), (Matcher)IsIterableContainingInOrder.contains((Object[])expected.toArray()));
    }

    public static <StreamMessageType> void containsInOrder(Map<Integer, List<StreamMessageType>> expected, InMemoryOutputDescriptor<StreamMessageType> outputDescriptor, Duration timeout) throws InterruptedException {
        Preconditions.checkNotNull(outputDescriptor);
        Map actual = TestRunner.consumeStream(outputDescriptor, timeout);
        for (Integer paritionId : expected.keySet()) {
            Assert.assertThat(actual.get(paritionId), (Matcher)IsIterableContainingInOrder.contains((Object[])expected.get(paritionId).toArray()));
        }
    }
}

