/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.test.framework.system.descriptors;

import java.util.HashMap;
import java.util.Map;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.descriptors.OutputDescriptorProvider;
import org.apache.samza.system.descriptors.SimpleInputDescriptorProvider;
import org.apache.samza.system.descriptors.SystemDescriptor;
import org.apache.samza.system.inmemory.InMemorySystemFactory;
import org.apache.samza.test.framework.system.descriptors.InMemoryInputDescriptor;
import org.apache.samza.test.framework.system.descriptors.InMemoryOutputDescriptor;

public class InMemorySystemDescriptor
extends SystemDescriptor<InMemorySystemDescriptor>
implements SimpleInputDescriptorProvider,
OutputDescriptorProvider {
    private static final String FACTORY_CLASS_NAME = InMemorySystemFactory.class.getName();
    private String inMemoryScope;

    public InMemorySystemDescriptor(String systemName) {
        super(systemName, FACTORY_CLASS_NAME, null, null);
        this.withDefaultStreamOffsetDefault(SystemStreamMetadata.OffsetType.OLDEST);
    }

    public <StreamMessageType> InMemoryInputDescriptor<StreamMessageType> getInputDescriptor(String streamId, Serde<StreamMessageType> serde) {
        return new InMemoryInputDescriptor(streamId, this);
    }

    public <StreamMessageType> InMemoryOutputDescriptor<StreamMessageType> getOutputDescriptor(String streamId, Serde<StreamMessageType> serde) {
        return new InMemoryOutputDescriptor(streamId, this);
    }

    public InMemorySystemDescriptor withInMemoryScope(String inMemoryScope) {
        this.inMemoryScope = inMemoryScope;
        return this;
    }

    public Map<String, String> toConfig() {
        HashMap<String, String> configs = new HashMap<String, String>(super.toConfig());
        configs.put("inmemory.scope", this.inMemoryScope);
        configs.put(String.format("systems.%s.samza.factory", this.getSystemName()), FACTORY_CLASS_NAME);
        return configs;
    }
}

