/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.test.integration;

import org.apache.samza.config.ConfigException;
import org.apache.samza.context.Context;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.system.SystemStream;
import org.apache.samza.task.InitableTask;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.StreamTask;
import org.apache.samza.task.TaskCoordinator;
import org.apache.samza.util.StreamUtil;

public class NegateNumberTask
implements StreamTask,
InitableTask {
    private static int messagesProcessed = 0;
    private int maxMessages;
    private SystemStream outputSystemStream;

    public void init(Context context) throws Exception {
        this.maxMessages = context.getJobContext().getConfig().getInt("task.max.messages", 50);
        String outputSystemStreamString = context.getJobContext().getConfig().get("task.outputs", null);
        if (outputSystemStreamString == null) {
            throw new ConfigException("Missing required configuration: task.outputs");
        }
        this.outputSystemStream = StreamUtil.getSystemStreamFromNames((String)outputSystemStreamString);
    }

    public void process(IncomingMessageEnvelope envelope, MessageCollector collector, TaskCoordinator coordinator) {
        String input = (String)envelope.getMessage();
        Integer number = Integer.valueOf(input);
        Integer output = number * -1;
        collector.send(new OutgoingMessageEnvelope(this.outputSystemStream, (Object)output.toString()));
        if (++messagesProcessed >= this.maxMessages) {
            coordinator.shutdown(TaskCoordinator.RequestScope.ALL_TASKS_IN_CONTAINER);
        }
    }
}

