/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.test.integration;

import org.apache.samza.context.Context;
import org.apache.samza.storage.kv.Entry;
import org.apache.samza.storage.kv.KeyValueIterator;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.task.InitableTask;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.StreamTask;
import org.apache.samza.task.TaskCoordinator;

public class SimpleStatefulTask
implements StreamTask,
InitableTask {
    private KeyValueStore<String, String> store;

    public void init(Context context) {
        this.store = context.getTaskContext().getStore("mystore");
        System.out.println("Contents of store: ");
        KeyValueIterator iter = this.store.all();
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            System.out.println((String)entry.getKey() + " => " + (String)entry.getValue());
        }
        iter.close();
    }

    public void process(IncomingMessageEnvelope envelope, MessageCollector collector, TaskCoordinator coordinator) {
        System.out.println("Adding " + envelope.getMessage() + " => " + envelope.getMessage() + " to the store.");
        this.store.put((Object)((String)envelope.getMessage()), (Object)((String)envelope.getMessage()));
        coordinator.commit(TaskCoordinator.RequestScope.ALL_TASKS_IN_CONTAINER);
    }
}

