/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.test.integration;

import org.apache.samza.context.Context;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.task.InitableTask;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.StreamTask;
import org.apache.samza.task.TaskCoordinator;

public class StatePerfTestTask
implements StreamTask,
InitableTask {
    private static final int LOG_INTERVAL = 100000;
    private KeyValueStore<String, String> store;
    private int count = 0;
    private long start = System.currentTimeMillis();

    public void init(Context context) {
        this.store = context.getTaskContext().getStore("mystore");
    }

    public void process(IncomingMessageEnvelope envelope, MessageCollector collector, TaskCoordinator coordinator) {
        this.store.put((Object)((String)envelope.getMessage()), (Object)((String)envelope.getMessage()));
        ++this.count;
        if (this.count % 100000 == 0) {
            double ellapsedSecs = (double)(System.currentTimeMillis() - this.start) / 1000.0;
            System.out.println(String.format("Throughput = %.2f messages/sec.", (double)this.count / ellapsedSecs));
            this.start = System.currentTimeMillis();
            this.count = 0;
            coordinator.commit(TaskCoordinator.RequestScope.ALL_TASKS_IN_CONTAINER);
        }
    }
}

