/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.test.integration;

import org.apache.samza.application.StreamApplication;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.NoOpSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.system.descriptors.OutputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaInputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaOutputDescriptor;
import org.apache.samza.system.kafka.descriptors.KafkaSystemDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStandaloneIntegrationApplication
implements StreamApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestStandaloneIntegrationApplication.class);

    public void describe(StreamApplicationDescriptor appDescriptor) {
        String systemName = "testSystemName";
        String inputStreamName = (String)appDescriptor.getConfig().get((Object)"input.stream.name");
        String outputStreamName = "standaloneIntegrationTestKafkaOutputTopic";
        LOGGER.info("Publishing message from: {} to: {}.", (Object)inputStreamName, (Object)outputStreamName);
        KafkaSystemDescriptor kafkaSystemDescriptor = new KafkaSystemDescriptor(systemName);
        KVSerde noOpSerde = KVSerde.of((Serde)new NoOpSerde(), (Serde)new NoOpSerde());
        KafkaInputDescriptor isd = kafkaSystemDescriptor.getInputDescriptor(inputStreamName, (Serde)noOpSerde);
        KafkaOutputDescriptor osd = kafkaSystemDescriptor.getOutputDescriptor(outputStreamName, (Serde)noOpSerde);
        appDescriptor.getInputStream((InputDescriptor)isd).sendTo(appDescriptor.getOutputStream((OutputDescriptor)osd));
    }
}

