/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.test.performance;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import joptsimple.OptionSet;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.samza.Partition;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.StorageConfig;
import org.apache.samza.container.TaskName;
import org.apache.samza.context.ContainerContext;
import org.apache.samza.context.ContainerContextImpl;
import org.apache.samza.context.JobContext;
import org.apache.samza.context.JobContextImpl;
import org.apache.samza.job.model.ContainerModel;
import org.apache.samza.job.model.TaskModel;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.MetricsRegistryMap;
import org.apache.samza.serializers.ByteSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.serializers.SerdeManager;
import org.apache.samza.serializers.SerdeManager$;
import org.apache.samza.storage.StorageEngine;
import org.apache.samza.storage.StorageEngineFactory;
import org.apache.samza.storage.kv.KeyValueStorageEngine;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.system.SystemProducers;
import org.apache.samza.system.SystemProducers$;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.TaskInstanceCollector;
import org.apache.samza.task.TaskInstanceCollector$;
import org.apache.samza.test.performance.TestKeyValuePerformance;
import org.apache.samza.test.performance.TestKeyValuePerformance$;
import org.apache.samza.util.CommandLine;
import org.apache.samza.util.FileUtil;
import org.apache.samza.util.Logging;
import org.apache.samza.util.ReflectionUtil;
import org.apache.samza.util.ScalaJavaUtil;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

public final class TestKeyValuePerformance$
implements Logging {
    public static final TestKeyValuePerformance$ MODULE$;
    private final String Encoding;
    private final String JobId;
    private final scala.collection.immutable.Map<String, Function2<KeyValueStorageEngine<byte[], byte[]>, Config, BoxedUnit>> testMethods;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    static {
        new TestKeyValuePerformance$();
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TestKeyValuePerformance$ testKeyValuePerformance$ = this;
        synchronized (testKeyValuePerformance$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        TestKeyValuePerformance$ testKeyValuePerformance$ = this;
        synchronized (testKeyValuePerformance$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging.class.startupLogger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    public void startupLog(Function0<Object> message) {
        Logging.class.startupLog((Logging)this, message);
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, message, e);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, message, e);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.info((Logging)this, message, e);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, message, e);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.error((Logging)this, message, e);
    }

    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging.class.putMDC((Logging)this, key, value);
    }

    public String getMDC(Function0<String> key) {
        return Logging.class.getMDC((Logging)this, key);
    }

    public void removeMDC(Function0<String> key) {
        Logging.class.removeMDC((Logging)this, key);
    }

    public void clearMDC() {
        Logging.class.clearMDC((Logging)this);
    }

    public String Encoding() {
        return this.Encoding;
    }

    public String JobId() {
        return this.JobId;
    }

    public scala.collection.immutable.Map<String, Function2<KeyValueStorageEngine<byte[], byte[]>, Config, BoxedUnit>> testMethods() {
        return this.testMethods;
    }

    public void main(String[] args) {
        CommandLine cmdline = new CommandLine();
        OptionSet options = cmdline.parser().parse(args);
        Config config = cmdline.loadConfig(options);
        String[] tests = ((String)config.get((Object)"test.methods")).split(",");
        Predef$.MODULE$.refArrayOps((Object[])tests).foreach((Function1)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final void apply(String test) {
                TestKeyValuePerformance$.MODULE$.info((Function0<Object>)new Serializable(this, test){
                    public static final long serialVersionUID = 0L;
                    private final String test$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Running test: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.test$1}));
                    }
                    {
                        this.test$1 = test$1;
                    }
                });
                if (TestKeyValuePerformance$.MODULE$.testMethods().contains((Object)test)) {
                    MapConfig testConfig = new MapConfig((java.util.Map)this.config$1.subset(new StringBuilder().append((Object)"test.").append((Object)test).append((Object)".").toString(), true));
                    ImmutableMap jobConfig = ImmutableMap.of((Object)"job.name", (Object)test, (Object)"job.id", (Object)TestKeyValuePerformance$.MODULE$.JobId());
                    MapConfig combinedConfig = new MapConfig((List)ImmutableList.of((Object)testConfig, (Object)jobConfig));
                    TestKeyValuePerformance$.MODULE$.invokeTest(test, (Function2<KeyValueStorageEngine<byte[], byte[]>, Config, BoxedUnit>)((Function2)TestKeyValuePerformance$.MODULE$.testMethods().apply((Object)test)), (Config)combinedConfig);
                    return;
                }
                TestKeyValuePerformance$.MODULE$.error((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Invalid test method. valid methods are: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TestKeyValuePerformance$.MODULE$.testMethods().keys()}));
                    }
                });
                throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("Unknown test method: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{test})));
            }
            {
                this.config$1 = config$1;
            }
        });
    }

    public void invokeTest(String testName, Function2<KeyValueStorageEngine<byte[], byte[]>, Config, BoxedUnit> testMethod, Config config) {
        int partitionCount = config.getInt("partition.count", 1);
        scala.collection.immutable.Map tasks = ((TraversableOnce)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionCount).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Partition apply(int i) {
                return new Partition(i);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TaskName, TaskModel> apply(Partition partition) {
                return new Tuple2((Object)new TaskName(partition.toString()), (Object)new TaskModel(new TaskName(partition.toString()), Collections.singleton(new SystemStreamPartition("system", "stream", partition)), partition));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        SystemProducers producerMultiplexer = new SystemProducers((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), new SerdeManager(SerdeManager$.MODULE$.$lessinit$greater$default$1(), SerdeManager$.MODULE$.$lessinit$greater$default$2(), SerdeManager$.MODULE$.$lessinit$greater$default$3(), SerdeManager$.MODULE$.$lessinit$greater$default$4(), SerdeManager$.MODULE$.$lessinit$greater$default$5(), SerdeManager$.MODULE$.$lessinit$greater$default$6(), SerdeManager$.MODULE$.$lessinit$greater$default$7(), SerdeManager$.MODULE$.$lessinit$greater$default$8()), SystemProducers$.MODULE$.$lessinit$greater$default$3(), SystemProducers$.MODULE$.$lessinit$greater$default$4());
        StorageConfig storageConfig = new StorageConfig(config);
        Buffer storageEngineMappings = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(storageConfig.getStoreNames()).asScala()).map((Function1)new Serializable(storageConfig){
            public static final long serialVersionUID = 0L;
            private final StorageConfig storageConfig$1;

            public final Tuple2<String, StorageEngineFactory<byte[], byte[]>> apply(String storeName) {
                String storageFactoryClassName = (String)ScalaJavaUtil.JavaOptionals$.MODULE$.toRichOptional(this.storageConfig$1.getStorageFactoryClassName(storeName)).toOption().getOrElse((Function0)new Serializable(this, storeName){
                    public static final long serialVersionUID = 0L;
                    private final String storeName$2;

                    public final Nothing$ apply() {
                        throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("Missing storage factory for %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.storeName$2})));
                    }
                    {
                        this.storeName$2 = storeName$2;
                    }
                });
                return new Tuple2((Object)storeName, ReflectionUtil.getObj((String)storageFactoryClassName, StorageEngineFactory.class));
            }
            {
                this.storageConfig$1 = storageConfig$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        storageEngineMappings.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, StorageEngineFactory<byte[], byte[]>> check$ifrefutable$1) {
                Tuple2<String, StorageEngineFactory<byte[], byte[]>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(testMethod, tasks, producerMultiplexer, storageConfig){
            public static final long serialVersionUID = 0L;
            public final Function2 testMethod$1;
            public final scala.collection.immutable.Map tasks$1;
            public final SystemProducers producerMultiplexer$1;
            public final StorageConfig storageConfig$1;

            public final void apply(Tuple2<String, StorageEngineFactory<byte[], byte[]>> x$1) {
                Tuple2<String, StorageEngineFactory<byte[], byte[]>> tuple2 = x$1;
                if (tuple2 != null) {
                    String storeName = (String)tuple2._1();
                    StorageEngineFactory storageEngine = (StorageEngineFactory)tuple2._2();
                    int testSetCount = this.storageConfig$1.getInt("set.count", 1);
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), testSetCount).foreach$mVc$sp((Function1)new Serializable(this, storeName, storageEngine){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.invokeTest.2 $outer;
                        private final String storeName$1;
                        private final StorageEngineFactory storageEngine$1;

                        public final void apply(int testSet) {
                            this.apply$mcVI$sp(testSet);
                        }

                        public void apply$mcVI$sp(int testSet) {
                            ByteSerde byteSerde;
                            File output = new File(new StringBuilder().append((Object)"/tmp/").append((Object)UUID.randomUUID()).toString());
                            StorageEngine engine = this.storageEngine$1.getStorageEngine(this.storeName$1, output, (Serde)(byteSerde = new ByteSerde()), (Serde)byteSerde, (MessageCollector)new TaskInstanceCollector(this.$outer.producerMultiplexer$1, TaskInstanceCollector$.MODULE$.$lessinit$greater$default$2()), (MetricsRegistry)new MetricsRegistryMap(), null, (JobContext)JobContextImpl.fromConfigWithDefaults((Config)this.$outer.storageConfig$1, null), (ContainerContext)new ContainerContextImpl(new ContainerModel("0", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.$outer.tasks$1).asJava()), (MetricsRegistry)new MetricsRegistryMap()), StorageEngineFactory.StoreMode.ReadWrite);
                            if (engine instanceof KeyValueStorageEngine) {
                                KeyValueStorageEngine db = (KeyValueStorageEngine)engine;
                                this.$outer.testMethod$1.apply((Object)db, (Object)this.$outer.storageConfig$1.subset(new StringBuilder().append((Object)"set-").append((Object)BoxesRunTime.boxToInteger((int)testSet)).append((Object)".").toString(), true));
                                new FileUtil().rm(output);
                                return;
                            }
                            throw new SamzaException("This test can only run with KeyValueStorageEngine configured as store factory.");
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.storeName$1 = storeName$1;
                            this.storageEngine$1 = storageEngine$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.testMethod$1 = testMethod$1;
                this.tasks$1 = tasks$1;
                this.producerMultiplexer$1 = producerMultiplexer$1;
                this.storageConfig$1 = storageConfig$1;
            }
        });
    }

    public void runTestAllWithDeletes(KeyValueStore<byte[], byte[]> db, Config config) {
        int numLoops = config.getInt("num.loops", 100);
        int messagesPerBatch = config.getInt("messages.per.batch", 10000);
        int messageSizeBytes = config.getInt("message.size.bytes", 200);
        this.info((Function0<Object>)new Serializable(numLoops, messagesPerBatch, messageSizeBytes){
            public static final long serialVersionUID = 0L;
            private final int numLoops$1;
            private final int messagesPerBatch$1;
            private final int messageSizeBytes$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Using (num loops, messages per batch, message size in bytes) => (%s, %s, %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numLoops$1), BoxesRunTime.boxToInteger((int)this.messagesPerBatch$1), BoxesRunTime.boxToInteger((int)this.messageSizeBytes$1)}));
            }
            {
                this.numLoops$1 = numLoops$1;
                this.messagesPerBatch$1 = messagesPerBatch$1;
                this.messageSizeBytes$1 = messageSizeBytes$1;
            }
        });
        new TestKeyValuePerformance().testAllWithDeletes(db, numLoops, messagesPerBatch, messageSizeBytes);
    }

    public void runTestMsgWritePerformance(KeyValueStore<byte[], byte[]> db, Config config) {
        int messageSizeBytes = config.getInt("message.size", 200);
        int messageCount = config.getInt("message.count", 10000);
        this.info((Function0<Object>)new Serializable(messageSizeBytes, messageCount){
            public static final long serialVersionUID = 0L;
            private final int messageSizeBytes$2;
            private final int messageCount$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Using (message count, message size in bytes) => (%s, %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messageCount$1), BoxesRunTime.boxToInteger((int)this.messageSizeBytes$2)}));
            }
            {
                this.messageSizeBytes$2 = messageSizeBytes$2;
                this.messageCount$1 = messageCount$1;
            }
        });
        new TestKeyValuePerformance().testMsgWritePerformance(db, messageCount, messageSizeBytes);
    }

    public void runTestConcurrentMsgWritePerformance(KeyValueStore<byte[], byte[]> db, Config config) {
        int messageSizeBytes = config.getInt("message.size", 200);
        int messageCount = config.getInt("message.count", 100000);
        int numThreads = config.getInt("num.threads", 4);
        new TestKeyValuePerformance().testConcurrentMsgWritePerformance(db, messageCount, messageSizeBytes, numThreads);
    }

    public void runTestGetAllVsGetWriteManyReadMany(KeyValueStore<byte[], byte[]> db, Config config) {
        new TestKeyValuePerformance().testGetAllVsGetWriteManyReadMany(db, config);
    }

    public void runTestGetAllVsGetWriteOnceReadMany(KeyValueStore<byte[], byte[]> db, Config config) {
        new TestKeyValuePerformance().testGetAllVsGetWriteOnceReadMany(db, config);
    }

    private TestKeyValuePerformance$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.Encoding = "UTF-8";
        this.JobId = RandomStringUtils.random((int)10);
        this.testMethods = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"all-with-deletes"), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(KeyValueStore<byte[], byte[]> db, Config config) {
                TestKeyValuePerformance$.MODULE$.runTestAllWithDeletes(db, config);
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rocksdb-write-performance"), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(KeyValueStore<byte[], byte[]> db, Config config) {
                TestKeyValuePerformance$.MODULE$.runTestMsgWritePerformance(db, config);
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rocksdb-concurrent-write-performance"), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(KeyValueStore<byte[], byte[]> db, Config config) {
                TestKeyValuePerformance$.MODULE$.runTestConcurrentMsgWritePerformance(db, config);
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"get-all-vs-get-write-many-read-many"), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(KeyValueStore<byte[], byte[]> db, Config config) {
                TestKeyValuePerformance$.MODULE$.runTestGetAllVsGetWriteManyReadMany(db, config);
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"get-all-vs-get-write-once-read-many"), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(KeyValueStore<byte[], byte[]> db, Config config) {
                TestKeyValuePerformance$.MODULE$.runTestGetAllVsGetWriteOnceReadMany(db, config);
            }
        })}));
    }
}

