/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.test.performance;

import com.google.common.base.Stopwatch;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.samza.config.Config;
import org.apache.samza.serializers.UUIDSerde;
import org.apache.samza.storage.kv.KeyValueIterator;
import org.apache.samza.storage.kv.KeyValueStorageEngine;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.test.performance.TestKeyValuePerformance$;
import org.apache.samza.util.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005mu!B\u0001\u0003\u0011\u0003i\u0011a\u0006+fgR\\U-\u001f,bYV,\u0007+\u001a:g_Jl\u0017M\\2f\u0015\t\u0019A!A\u0006qKJ4wN]7b]\u000e,'BA\u0003\u0007\u0003\u0011!Xm\u001d;\u000b\u0005\u001dA\u0011!B:b[j\f'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u000f\u001f5\t!AB\u0003\u0011\u0005!\u0005\u0011CA\fUKN$8*Z=WC2,X\rU3sM>\u0014X.\u00198dKN\u0019qB\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\tIB$D\u0001\u001b\u0015\tYb!\u0001\u0003vi&d\u0017BA\u000f\u001b\u0005\u001daunZ4j]\u001eDQaH\b\u0005\u0002\u0001\na\u0001P5oSRtD#A\u0007\t\u000f\tz!\u0019!C\u0001G\u0005AQI\\2pI&tw-F\u0001%!\t)#&D\u0001'\u0015\t9\u0003&\u0001\u0003mC:<'\"A\u0015\u0002\t)\fg/Y\u0005\u0003W\u0019\u0012aa\u0015;sS:<\u0007BB\u0017\u0010A\u0003%A%A\u0005F]\u000e|G-\u001b8hA!9qf\u0004b\u0001\n\u0003\u0019\u0013!\u0002&pE&#\u0007BB\u0019\u0010A\u0003%A%\u0001\u0004K_\nLE\r\t\u0005\bg=\u0011\r\u0011\"\u00015\u0003-!Xm\u001d;NKRDw\u000eZ:\u0016\u0003U\u0002BAN\u001d=}9\u00111cN\u0005\u0003qQ\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\ri\u0015\r\u001d\u0006\u0003qQ\u0001\"AN\u001f\n\u0005-Z\u0004#B\n@\u0003>+\u0016B\u0001!\u0015\u0005%1UO\\2uS>t'\u0007\u0005\u0003C\u000f&KU\"A\"\u000b\u0005\u0011+\u0015AA6w\u0015\t1e!A\u0004ti>\u0014\u0018mZ3\n\u0005!\u001b%!F&fsZ\u000bG.^3Ti>\u0014\u0018mZ3F]\u001eLg.\u001a\t\u0004')c\u0015BA&\u0015\u0005\u0015\t%O]1z!\t\u0019R*\u0003\u0002O)\t!!)\u001f;f!\t\u00016+D\u0001R\u0015\t\u0011f!\u0001\u0004d_:4\u0017nZ\u0005\u0003)F\u0013aaQ8oM&<\u0007CA\nW\u0013\t9FC\u0001\u0003V]&$\bBB-\u0010A\u0003%Q'\u0001\u0007uKN$X*\u001a;i_\u0012\u001c\b\u0005C\u0003\\\u001f\u0011\u0005A,\u0001\u0003nC&tGCA+^\u0011\u0015q&\f1\u0001`\u0003\u0011\t'oZ:\u0011\u0007MQE\bC\u0003b\u001f\u0011\u0005!-\u0001\u0006j]Z|7.\u001a+fgR$B!V2fO\")A\r\u0019a\u0001y\u0005AA/Z:u\u001d\u0006lW\rC\u0003gA\u0002\u0007a(\u0001\u0006uKN$X*\u001a;i_\u0012DQA\u00151A\u0002=CQ![\b\u0005\u0002)\fQC];o)\u0016\u001cH/\u00117m/&$\b\u000eR3mKR,7\u000fF\u0002VWBDQ\u0001\u001c5A\u00025\f!\u0001\u001a2\u0011\t\ts\u0017*S\u0005\u0003_\u000e\u0013QbS3z-\u0006dW/Z*u_J,\u0007\"\u0002*i\u0001\u0004y\u0005\"\u0002:\u0010\t\u0003\u0019\u0018A\u0007:v]R+7\u000f^'tO^\u0013\u0018\u000e^3QKJ4wN]7b]\u000e,GcA+uk\")A.\u001da\u0001[\")!+\u001da\u0001\u001f\")qo\u0004C\u0001q\u0006!#/\u001e8UKN$8i\u001c8dkJ\u0014XM\u001c;Ng\u001e<&/\u001b;f!\u0016\u0014hm\u001c:nC:\u001cW\rF\u0002VsjDQ\u0001\u001c<A\u00025DQA\u0015<A\u0002=CQ\u0001`\b\u0005\u0002u\f1E];o)\u0016\u001cHoR3u\u00032dgk]$fi^\u0013\u0018\u000e^3NC:L(+Z1e\u001b\u0006t\u0017\u0010F\u0002V}~DQ\u0001\\>A\u00025DQAU>A\u0002=Cq!a\u0001\u0010\t\u0003\t)!A\u0012sk:$Vm\u001d;HKR\fE\u000e\u001c,t\u000f\u0016$xK]5uK>s7-\u001a*fC\u0012l\u0015M\\=\u0015\u000bU\u000b9!!\u0003\t\r1\f\t\u00011\u0001n\u0011\u0019\u0011\u0016\u0011\u0001a\u0001\u001f\u001a)\u0001C\u0001\u0001\u0002\u000eM!\u00111\u0002\n\u0019\u0011\u001dy\u00121\u0002C\u0001\u0003#!\"!a\u0005\u0011\u00079\tY\u0001\u0003\u0005\u0002\u0018\u0005-A\u0011AA\r\u0003I!Xm\u001d;BY2<\u0016\u000e\u001e5EK2,G/Z:\u0015\u0013U\u000bY\"a\b\u0002*\u00055\u0002bBA\u000f\u0003+\u0001\r!\\\u0001\u0006gR|'/\u001a\u0005\u000b\u0003C\t)\u0002%AA\u0002\u0005\r\u0012\u0001\u00038v[2{w\u000e]:\u0011\u0007M\t)#C\u0002\u0002(Q\u00111!\u00138u\u0011)\tY#!\u0006\u0011\u0002\u0003\u0007\u00111E\u0001\u0011[\u0016\u001c8/Y4fgB+'OQ1uG\"D!\"a\f\u0002\u0016A\u0005\t\u0019AA\u0012\u0003AiWm]:bO\u0016\u001c\u0016N_3CsR,7\u000f\u0003\u0005\u00024\u0005-A\u0011AA\u001b\u0003]!Xm\u001d;Ng\u001e<&/\u001b;f!\u0016\u0014hm\u001c:nC:\u001cW\rF\u0004V\u0003o\tI$!\u0010\t\u000f\u0005u\u0011\u0011\u0007a\u0001[\"Q\u00111HA\u0019!\u0003\u0005\r!a\t\u0002\u000f9,X.T:hg\"Q\u0011qHA\u0019!\u0003\u0005\r!a\t\u0002\u001d5\u001cxmU5{K&s')\u001f;fg\"A\u00111IA\u0006\t\u0003\t)%A\u0011uKN$8i\u001c8dkJ\u0014XM\u001c;Ng\u001e<&/\u001b;f!\u0016\u0014hm\u001c:nC:\u001cW\rF\u0005V\u0003\u000f\nI%a\u0013\u0002N!9\u0011QDA!\u0001\u0004i\u0007BCA\u001e\u0003\u0003\u0002\n\u00111\u0001\u0002$!Q\u0011qHA!!\u0003\u0005\r!a\t\t\u0015\u0005=\u0013\u0011\tI\u0001\u0002\u0004\t\u0019#\u0001\u0006ok6$\u0006N]3bIND\u0001\"a\u0015\u0002\f\u0011\u0005\u0011QK\u0001!i\u0016\u001cHoR3u\u00032dgk]$fi^\u0013\u0018\u000e^3NC:L(+Z1e\u001b\u0006t\u0017\u0010F\u0003V\u0003/\nI\u0006C\u0004\u0002\u001e\u0005E\u0003\u0019A7\t\rI\u000b\t\u00061\u0001P\u0011!\ti&a\u0003\u0005\u0002\u0005}\u0013\u0001\t;fgR<U\r^!mYZ\u001bx)\u001a;Xe&$Xm\u00148dKJ+\u0017\rZ'b]f$R!VA1\u0003GBq!!\b\u0002\\\u0001\u0007Q\u000e\u0003\u0004S\u00037\u0002\ra\u0014\u0005\u000b\u0003O\nY!%A\u0005\u0002\u0005%\u0014\u0001\b;fgR\fE\u000e\\,ji\"$U\r\\3uKN$C-\u001a4bk2$HEM\u000b\u0003\u0003WRC!a\t\u0002n-\u0012\u0011q\u000e\t\u0005\u0003c\nY(\u0004\u0002\u0002t)!\u0011QOA<\u0003%)hn\u00195fG.,GMC\u0002\u0002zQ\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti(a\u001d\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0002\u0002\u0006-\u0011\u0013!C\u0001\u0003S\nA\u0004^3ti\u0006cGnV5uQ\u0012+G.\u001a;fg\u0012\"WMZ1vYR$3\u0007\u0003\u0006\u0002\u0006\u0006-\u0011\u0013!C\u0001\u0003S\nA\u0004^3ti\u0006cGnV5uQ\u0012+G.\u001a;fg\u0012\"WMZ1vYR$C\u0007\u0003\u0006\u0002\n\u0006-\u0011\u0013!C\u0001\u0003S\n\u0011\u0005^3ti6\u001bxm\u0016:ji\u0016\u0004VM\u001d4pe6\fgnY3%I\u00164\u0017-\u001e7uIIB!\"!$\u0002\fE\u0005I\u0011AA5\u0003\u0005\"Xm\u001d;Ng\u001e<&/\u001b;f!\u0016\u0014hm\u001c:nC:\u001cW\r\n3fM\u0006,H\u000e\u001e\u00134\u0011)\t\t*a\u0003\u0012\u0002\u0013\u0005\u0011\u0011N\u0001,i\u0016\u001cHoQ8oGV\u0014(/\u001a8u\u001bN<wK]5uKB+'OZ8s[\u0006t7-\u001a\u0013eK\u001a\fW\u000f\u001c;%e!Q\u0011QSA\u0006#\u0003%\t!!\u001b\u0002WQ,7\u000f^\"p]\u000e,(O]3oi6\u001bxm\u0016:ji\u0016\u0004VM\u001d4pe6\fgnY3%I\u00164\u0017-\u001e7uIMB!\"!'\u0002\fE\u0005I\u0011AA5\u0003-\"Xm\u001d;D_:\u001cWO\u001d:f]Rl5oZ,sSR,\u0007+\u001a:g_Jl\u0017M\\2fI\u0011,g-Y;mi\u0012\"\u0004")
public class TestKeyValuePerformance
implements Logging {
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public static void runTestGetAllVsGetWriteOnceReadMany(KeyValueStore<byte[], byte[]> keyValueStore, Config config) {
        TestKeyValuePerformance$.MODULE$.runTestGetAllVsGetWriteOnceReadMany(keyValueStore, config);
    }

    public static void runTestGetAllVsGetWriteManyReadMany(KeyValueStore<byte[], byte[]> keyValueStore, Config config) {
        TestKeyValuePerformance$.MODULE$.runTestGetAllVsGetWriteManyReadMany(keyValueStore, config);
    }

    public static void runTestConcurrentMsgWritePerformance(KeyValueStore<byte[], byte[]> keyValueStore, Config config) {
        TestKeyValuePerformance$.MODULE$.runTestConcurrentMsgWritePerformance(keyValueStore, config);
    }

    public static void runTestMsgWritePerformance(KeyValueStore<byte[], byte[]> keyValueStore, Config config) {
        TestKeyValuePerformance$.MODULE$.runTestMsgWritePerformance(keyValueStore, config);
    }

    public static void runTestAllWithDeletes(KeyValueStore<byte[], byte[]> keyValueStore, Config config) {
        TestKeyValuePerformance$.MODULE$.runTestAllWithDeletes(keyValueStore, config);
    }

    public static void invokeTest(String string, Function2<KeyValueStorageEngine<byte[], byte[]>, Config, BoxedUnit> function2, Config config) {
        TestKeyValuePerformance$.MODULE$.invokeTest(string, function2, config);
    }

    public static void main(String[] stringArray) {
        TestKeyValuePerformance$.MODULE$.main(stringArray);
    }

    public static Map<String, Function2<KeyValueStorageEngine<byte[], byte[]>, Config, BoxedUnit>> testMethods() {
        return TestKeyValuePerformance$.MODULE$.testMethods();
    }

    public static String JobId() {
        return TestKeyValuePerformance$.MODULE$.JobId();
    }

    public static String Encoding() {
        return TestKeyValuePerformance$.MODULE$.Encoding();
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TestKeyValuePerformance testKeyValuePerformance = this;
        synchronized (testKeyValuePerformance) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        TestKeyValuePerformance testKeyValuePerformance = this;
        synchronized (testKeyValuePerformance) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging.class.startupLogger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    public void startupLog(Function0<Object> message) {
        Logging.class.startupLog((Logging)this, message);
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, message, e);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, message, e);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.info((Logging)this, message, e);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, message, e);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.error((Logging)this, message, e);
    }

    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging.class.putMDC((Logging)this, key, value);
    }

    public String getMDC(Function0<String> key) {
        return Logging.class.getMDC((Logging)this, key);
    }

    public void removeMDC(Function0<String> key) {
        Logging.class.removeMDC((Logging)this, key);
    }

    public void clearMDC() {
        Logging.class.clearMDC((Logging)this);
    }

    public void testAllWithDeletes(KeyValueStore<byte[], byte[]> store, int numLoops, int messagesPerBatch, int messageSizeBytes) {
        byte[] stuff = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messageSizeBytes).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return "a";
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString().getBytes(TestKeyValuePerformance$.MODULE$.Encoding());
        long start = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numLoops).foreach$mVc$sp((Function1)new Serializable(this, store, messagesPerBatch, stuff, start){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestKeyValuePerformance $outer;
            public final KeyValueStore store$1;
            public final int messagesPerBatch$2;
            public final byte[] stuff$1;
            public final long start$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.info((Function0<Object>)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAllWithDeletes$1 $outer;
                    private final int i$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("(%sms) Total written to store: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.$outer.start$1)), BoxesRunTime.boxToInteger((int)(this.i$1 * this.$outer.messagesPerBatch$2))}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                });
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.messagesPerBatch$2).foreach$mVc$sp((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAllWithDeletes$1 $outer;
                    private final int i$1;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        byte[] k = ((Object)BoxesRunTime.boxToInteger((int)(this.i$1 * j))).toString().getBytes(TestKeyValuePerformance$.MODULE$.Encoding());
                        this.$outer.store$1.put((Object)k, (Object)this.$outer.stuff$1);
                        this.$outer.store$1.delete((Object)k);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                });
                long allStart = System.currentTimeMillis();
                KeyValueIterator iter = this.store$1.all();
                this.$outer.info((Function0<Object>)new Serializable(this, allStart){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAllWithDeletes$1 $outer;
                    private final long allStart$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("(%sms) all() took %sms.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.$outer.start$1)), BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.allStart$1))}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.allStart$1 = allStart$1;
                    }
                });
                iter.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.store$1 = store$1;
                this.messagesPerBatch$2 = messagesPerBatch$2;
                this.stuff$1 = stuff$1;
                this.start$1 = start$1;
            }
        });
        this.info((Function0<Object>)new Serializable(this, start){
            public static final long serialVersionUID = 0L;
            private final long start$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Total time: %ss")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)(System.currentTimeMillis() - this.start$1) * 0.001))}));
            }
            {
                this.start$1 = start$1;
            }
        });
    }

    public int testAllWithDeletes$default$2() {
        return 100;
    }

    public int testAllWithDeletes$default$3() {
        return 10000;
    }

    public int testAllWithDeletes$default$4() {
        return 200;
    }

    public void testMsgWritePerformance(KeyValueStore<byte[], byte[]> store, int numMsgs, int msgSizeInBytes) {
        byte[] msg = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), msgSizeInBytes).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return "x";
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString().getBytes(TestKeyValuePerformance$.MODULE$.Encoding());
        long start = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMsgs).foreach$mVc$sp((Function1)new Serializable(this, store, msg){
            public static final long serialVersionUID = 0L;
            private final KeyValueStore store$2;
            private final byte[] msg$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.store$2.put((Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(TestKeyValuePerformance$.MODULE$.Encoding()), (Object)this.msg$1);
            }
            {
                this.store$2 = store$2;
                this.msg$1 = msg$1;
            }
        });
        long timeTaken = System.currentTimeMillis() - start;
        this.info((Function0<Object>)new Serializable(this, numMsgs, msgSizeInBytes, timeTaken){
            public static final long serialVersionUID = 0L;
            private final int numMsgs$1;
            private final int msgSizeInBytes$1;
            private final long timeTaken$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Total time to write %d msgs of size %d bytes : %s s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numMsgs$1), BoxesRunTime.boxToInteger((int)this.msgSizeInBytes$1), BoxesRunTime.boxToDouble((double)((double)this.timeTaken$1 * 0.001))}));
            }
            {
                this.numMsgs$1 = numMsgs$1;
                this.msgSizeInBytes$1 = msgSizeInBytes$1;
                this.timeTaken$1 = timeTaken$1;
            }
        });
    }

    public int testMsgWritePerformance$default$2() {
        return 10000;
    }

    public int testMsgWritePerformance$default$3() {
        return 200;
    }

    public void testConcurrentMsgWritePerformance(KeyValueStore<byte[], byte[]> store, int numMsgs, int msgSizeInBytes, int numThreads) {
        byte[] msg = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), msgSizeInBytes).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return "x";
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString().getBytes(TestKeyValuePerformance$.MODULE$.Encoding());
        IndexedSeq threads = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numThreads).map((Function1)new Serializable(this, store, numMsgs, msg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestKeyValuePerformance $outer;
            private final KeyValueStore store$3;
            private final int numMsgs$2;
            private final byte[] msg$2;

            public final Thread apply(int i) {
                return this.$outer.org$apache$samza$test$performance$TestKeyValuePerformance$$createThread$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writer ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), this.store$3, this.numMsgs$2, this.msg$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.store$3 = store$3;
                this.numMsgs$2 = numMsgs$2;
                this.msg$2 = msg$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        long start = System.currentTimeMillis();
        threads.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Thread x$2) {
                x$2.start();
            }
        });
        threads.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Thread x$3) {
                x$3.join();
            }
        });
        long timeTaken = System.currentTimeMillis() - start;
        this.info((Function0<Object>)new Serializable(this, numMsgs, msgSizeInBytes, numThreads, timeTaken){
            public static final long serialVersionUID = 0L;
            private final int numMsgs$2;
            private final int msgSizeInBytes$2;
            private final int numThreads$1;
            private final long timeTaken$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Total time to write %d msgs of size %d bytes with %s threads: %s sec")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numMsgs$2), BoxesRunTime.boxToInteger((int)this.msgSizeInBytes$2), BoxesRunTime.boxToInteger((int)this.numThreads$1), BoxesRunTime.boxToDouble((double)((double)this.timeTaken$2 * 0.001))}));
            }
            {
                this.numMsgs$2 = numMsgs$2;
                this.msgSizeInBytes$2 = msgSizeInBytes$2;
                this.numThreads$1 = numThreads$1;
                this.timeTaken$2 = timeTaken$2;
            }
        });
    }

    public int testConcurrentMsgWritePerformance$default$2() {
        return 100000;
    }

    public int testConcurrentMsgWritePerformance$default$3() {
        return 200;
    }

    public int testConcurrentMsgWritePerformance$default$4() {
        return 4;
    }

    public void testGetAllVsGetWriteManyReadMany(KeyValueStore<byte[], byte[]> store, Config config) {
        int iterationsCount = config.getInt("iterations.count", 100);
        int maxMessagesCountPerBatch = config.getInt("message.max-count-per-batch", 100000);
        int maxMessageSizeBytes = config.getInt("message.max-size.bytes", 1024);
        Stopwatch timer = Stopwatch.createUnstarted();
        UUIDSerde uuidSerde = new UUIDSerde();
        this.info((Function0<Object>)new Serializable(this, iterationsCount){
            public static final long serialVersionUID = 0L;
            private final int iterationsCount$1;

            public final String apply() {
                return new StringBuilder().append((Object)"iterations count: ").append((Object)BoxesRunTime.boxToInteger((int)this.iterationsCount$1)).toString();
            }
            {
                this.iterationsCount$1 = iterationsCount$1;
            }
        });
        this.info((Function0<Object>)new Serializable(this, maxMessagesCountPerBatch){
            public static final long serialVersionUID = 0L;
            private final int maxMessagesCountPerBatch$1;

            public final String apply() {
                return new StringBuilder().append((Object)"max messages count per batch: ").append((Object)BoxesRunTime.boxToInteger((int)this.maxMessagesCountPerBatch$1)).toString();
            }
            {
                this.maxMessagesCountPerBatch$1 = maxMessagesCountPerBatch$1;
            }
        });
        this.info((Function0<Object>)new Serializable(this, maxMessageSizeBytes){
            public static final long serialVersionUID = 0L;
            private final int maxMessageSizeBytes$1;

            public final String apply() {
                return new StringBuilder().append((Object)"max message size in bytes: ").append((Object)BoxesRunTime.boxToInteger((int)this.maxMessageSizeBytes$1)).toString();
            }
            {
                this.maxMessageSizeBytes$1 = maxMessageSizeBytes$1;
            }
        });
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("%12s%12s%12s%12s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Msg Count", "Bytes/Msg", "get ms", "getAll ms"}));
            }
        });
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), iterationsCount).foreach$mVc$sp((Function1)new Serializable(this, store, maxMessagesCountPerBatch, maxMessageSizeBytes, timer, uuidSerde){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TestKeyValuePerformance $outer;
                public final KeyValueStore store$4;
                private final int maxMessagesCountPerBatch$1;
                private final int maxMessageSizeBytes$1;
                private final Stopwatch timer$1;
                public final UUIDSerde uuidSerde$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    int messageSizeBytes = Random$.MODULE$.nextInt(this.maxMessageSizeBytes$1);
                    int messagesCountPerBatch = Random$.MODULE$.nextInt(this.maxMessagesCountPerBatch$1);
                    List keys = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messagesCountPerBatch).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testGetAllVsGetWriteManyReadMany$1 $outer;

                        public final byte[] apply(int k) {
                            return this.$outer.uuidSerde$1.toBytes(UUID.randomUUID());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom())).toList();
                    List shuffledKeys = (List)Random$.MODULE$.shuffle((TraversableOnce)keys, List$.MODULE$.canBuildFrom());
                    keys.foreach((Function1)new Serializable(this, messageSizeBytes){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testGetAllVsGetWriteManyReadMany$1 $outer;
                        private final int messageSizeBytes$3;

                        public final void apply(byte[] k) {
                            this.$outer.store$4.put((Object)k, (Object)Random$.MODULE$.nextString(this.messageSizeBytes$3).getBytes(TestKeyValuePerformance$.MODULE$.Encoding()));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.messageSizeBytes$3 = messageSizeBytes$3;
                        }
                    });
                    this.store$4.flush();
                    this.timer$1.reset().start();
                    Predef$.MODULE$.assert(this.store$4.getAll((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)shuffledKeys).asJava()).size() == shuffledKeys.size());
                    long getAllTime = this.timer$1.stop().elapsed(TimeUnit.MILLISECONDS);
                    keys.foreach((Function1)new Serializable(this, messageSizeBytes){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testGetAllVsGetWriteManyReadMany$1 $outer;
                        private final int messageSizeBytes$3;

                        public final void apply(byte[] k) {
                            this.$outer.store$4.put((Object)k, (Object)Random$.MODULE$.nextString(this.messageSizeBytes$3).getBytes(TestKeyValuePerformance$.MODULE$.Encoding()));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.messageSizeBytes$3 = messageSizeBytes$3;
                        }
                    });
                    this.store$4.flush();
                    this.timer$1.reset().start();
                    shuffledKeys.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testGetAllVsGetWriteManyReadMany$1 $outer;

                        public final byte[] apply(byte[] x$1) {
                            return (byte[])this.$outer.store$4.get((Object)x$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    long getTime = this.timer$1.stop().elapsed(TimeUnit.MILLISECONDS);
                    this.$outer.info((Function0<Object>)new Serializable(this, messageSizeBytes, messagesCountPerBatch, getAllTime, getTime){
                        public static final long serialVersionUID = 0L;
                        private final int messageSizeBytes$3;
                        private final int messagesCountPerBatch$1;
                        private final long getAllTime$1;
                        private final long getTime$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("%12d%12d%12d%12d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messagesCountPerBatch$1), BoxesRunTime.boxToInteger((int)this.messageSizeBytes$3), BoxesRunTime.boxToLong((long)this.getTime$1), BoxesRunTime.boxToLong((long)this.getAllTime$1)}));
                        }
                        {
                            this.messageSizeBytes$3 = messageSizeBytes$3;
                            this.messagesCountPerBatch$1 = messagesCountPerBatch$1;
                            this.getAllTime$1 = getAllTime$1;
                            this.getTime$1 = getTime$1;
                        }
                    });
                    if (getAllTime > getTime) {
                        this.$outer.error((Function0<Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "getAll was slower than get!";
                            }
                        });
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.store$4 = store$4;
                    this.maxMessagesCountPerBatch$1 = maxMessagesCountPerBatch$1;
                    this.maxMessageSizeBytes$1 = maxMessageSizeBytes$1;
                    this.timer$1 = timer$1;
                    this.uuidSerde$1 = uuidSerde$1;
                }
            });
            return;
        }
        finally {
            store.close();
        }
    }

    public void testGetAllVsGetWriteOnceReadMany(KeyValueStore<byte[], byte[]> store, Config config) {
        int iterationsCount = config.getInt("iterations.count", 100);
        int maxMessagesCountPerBatch = config.getInt("message.max-count-per-batch", 10000 + Random$.MODULE$.nextInt(20000));
        int maxMessageSizeBytes = config.getInt("message.max-size.bytes", 1024);
        int totalMessagesCount = iterationsCount * maxMessagesCountPerBatch;
        Stopwatch timer = Stopwatch.createUnstarted();
        UUIDSerde uuidSerde = new UUIDSerde();
        this.info((Function0<Object>)new Serializable(this, totalMessagesCount){
            public static final long serialVersionUID = 0L;
            private final int totalMessagesCount$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("write once -- putting %d messages in store")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.totalMessagesCount$1)}));
            }
            {
                this.totalMessagesCount$1 = totalMessagesCount$1;
            }
        });
        List keys = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), totalMessagesCount).map((Function1)new Serializable(this, uuidSerde){
            public static final long serialVersionUID = 0L;
            private final UUIDSerde uuidSerde$2;

            public final byte[] apply(int k) {
                return this.uuidSerde$2.toBytes(UUID.randomUUID());
            }
            {
                this.uuidSerde$2 = uuidSerde$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toList();
        keys.foreach((Function1)new Serializable(this, store, maxMessageSizeBytes){
            public static final long serialVersionUID = 0L;
            private final KeyValueStore store$5;
            private final int maxMessageSizeBytes$2;

            public final void apply(byte[] k) {
                this.store$5.put((Object)k, (Object)Random$.MODULE$.nextString(Random$.MODULE$.nextInt(this.maxMessageSizeBytes$2)).getBytes(TestKeyValuePerformance$.MODULE$.Encoding()));
            }
            {
                this.store$5 = store$5;
                this.maxMessageSizeBytes$2 = maxMessageSizeBytes$2;
            }
        });
        store.flush();
        this.info((Function0<Object>)new Serializable(this, iterationsCount){
            public static final long serialVersionUID = 0L;
            private final int iterationsCount$2;

            public final String apply() {
                return new StringBuilder().append((Object)"iterations count: ").append((Object)BoxesRunTime.boxToInteger((int)this.iterationsCount$2)).toString();
            }
            {
                this.iterationsCount$2 = iterationsCount$2;
            }
        });
        this.info((Function0<Object>)new Serializable(this, maxMessagesCountPerBatch){
            public static final long serialVersionUID = 0L;
            private final int maxMessagesCountPerBatch$2;

            public final String apply() {
                return new StringBuilder().append((Object)"max messages count per batch: ").append((Object)BoxesRunTime.boxToInteger((int)this.maxMessagesCountPerBatch$2)).toString();
            }
            {
                this.maxMessagesCountPerBatch$2 = maxMessagesCountPerBatch$2;
            }
        });
        this.info((Function0<Object>)new Serializable(this, maxMessageSizeBytes){
            public static final long serialVersionUID = 0L;
            private final int maxMessageSizeBytes$2;

            public final String apply() {
                return new StringBuilder().append((Object)"max message size in bytes: ").append((Object)BoxesRunTime.boxToInteger((int)this.maxMessageSizeBytes$2)).toString();
            }
            {
                this.maxMessageSizeBytes$2 = maxMessageSizeBytes$2;
            }
        });
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("%12s%12s%12s%12s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Msg Count", "Total Size", "get ms", "getAll ms"}));
            }
        });
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), iterationsCount).foreach$mVc$sp((Function1)new Serializable(this, store, maxMessagesCountPerBatch, timer, keys){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TestKeyValuePerformance $outer;
                public final KeyValueStore store$5;
                private final int maxMessagesCountPerBatch$2;
                private final Stopwatch timer$2;
                private final List keys$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    int messagesCountPerBatch = Random$.MODULE$.nextInt(this.maxMessagesCountPerBatch$2);
                    List shuffledKeys = ((List)Random$.MODULE$.shuffle((TraversableOnce)this.keys$1, List$.MODULE$.canBuildFrom())).take(messagesCountPerBatch);
                    int totalSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.store$5.getAll((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)shuffledKeys).asJava()).values()).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(byte[] x$4) {
                            return x$4.length;
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                    this.timer$2.reset().start();
                    Predef$.MODULE$.assert(this.store$5.getAll((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)shuffledKeys).asJava()).size() == shuffledKeys.size());
                    long getAllTime = this.timer$2.stop().elapsed(TimeUnit.MILLISECONDS);
                    shuffledKeys.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testGetAllVsGetWriteOnceReadMany$1 $outer;

                        public final byte[] apply(byte[] x$1) {
                            return (byte[])this.$outer.store$5.get((Object)x$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.timer$2.reset().start();
                    shuffledKeys.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testGetAllVsGetWriteOnceReadMany$1 $outer;

                        public final byte[] apply(byte[] x$1) {
                            return (byte[])this.$outer.store$5.get((Object)x$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    long getTime = this.timer$2.stop().elapsed(TimeUnit.MILLISECONDS);
                    this.$outer.info((Function0<Object>)new Serializable(this, messagesCountPerBatch, totalSize, getAllTime, getTime){
                        public static final long serialVersionUID = 0L;
                        private final int messagesCountPerBatch$2;
                        private final int totalSize$1;
                        private final long getAllTime$2;
                        private final long getTime$2;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("%12d%12d%12d%12d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messagesCountPerBatch$2), BoxesRunTime.boxToInteger((int)this.totalSize$1), BoxesRunTime.boxToLong((long)this.getTime$2), BoxesRunTime.boxToLong((long)this.getAllTime$2)}));
                        }
                        {
                            this.messagesCountPerBatch$2 = messagesCountPerBatch$2;
                            this.totalSize$1 = totalSize$1;
                            this.getAllTime$2 = getAllTime$2;
                            this.getTime$2 = getTime$2;
                        }
                    });
                    if (getAllTime > getTime) {
                        this.$outer.error((Function0<Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "getAll was slower than get!";
                            }
                        });
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.store$5 = store$5;
                    this.maxMessagesCountPerBatch$2 = maxMessagesCountPerBatch$2;
                    this.timer$2 = timer$2;
                    this.keys$1 = keys$1;
                }
            });
            return;
        }
        finally {
            store.close();
        }
    }

    public final Thread org$apache$samza$test$performance$TestKeyValuePerformance$$createThread$1(String name, KeyValueStore store$3, int numMsgs$2, byte[] msg$2) {
        return new Thread(new Runnable(this, store$3, numMsgs$2, msg$2){
            public final KeyValueStore store$3;
            private final int numMsgs$2;
            public final byte[] msg$2;

            public void run() {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numMsgs$2).foreach$mVc$sp((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.$outer.store$3.put((Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(TestKeyValuePerformance$.MODULE$.Encoding()), (Object)this.$outer.msg$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.store$3 = store$3;
                this.numMsgs$2 = numMsgs$2;
                this.msg$2 = msg$2;
            }
        }, name);
    }

    public TestKeyValuePerformance() {
        Logging.class.$init$((Logging)this);
    }
}

