/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.test.performance;

import org.apache.samza.config.Config;
import org.apache.samza.context.Context;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.system.SystemStream;
import org.apache.samza.task.InitableTask;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.StreamTask;
import org.apache.samza.task.TaskCoordinator;
import org.apache.samza.test.performance.TestPerformanceTask$;
import org.apache.samza.util.Logging;
import org.apache.samza.util.StreamUtil;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rr!B\u0001\u0003\u0011\u0003i\u0011a\u0005+fgR\u0004VM\u001d4pe6\fgnY3UCN\\'BA\u0002\u0005\u0003-\u0001XM\u001d4pe6\fgnY3\u000b\u0005\u00151\u0011\u0001\u0002;fgRT!a\u0002\u0005\u0002\u000bM\fWN_1\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001!\tqq\"D\u0001\u0003\r\u0015\u0001\"\u0001#\u0001\u0012\u0005M!Vm\u001d;QKJ4wN]7b]\u000e,G+Y:l'\ty!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\u0005\u00063=!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035Aq\u0001H\bA\u0002\u0013\u0005Q$A\tnKN\u001c\u0018mZ3t!J|7-Z:tK\u0012,\u0012A\b\t\u0003'}I!\u0001\t\u000b\u0003\u0007%sG\u000fC\u0004#\u001f\u0001\u0007I\u0011A\u0012\u0002+5,7o]1hKN\u0004&o\\2fgN,Gm\u0018\u0013fcR\u0011Ae\n\t\u0003'\u0015J!A\n\u000b\u0003\tUs\u0017\u000e\u001e\u0005\bQ\u0005\n\t\u00111\u0001\u001f\u0003\rAH%\r\u0005\u0007U=\u0001\u000b\u0015\u0002\u0010\u0002%5,7o]1hKN\u0004&o\\2fgN,G\r\t\u0005\bY=\u0001\r\u0011\"\u0001.\u0003%\u0019H/\u0019:u)&lW-F\u0001/!\t\u0019r&\u0003\u00021)\t!Aj\u001c8h\u0011\u001d\u0011t\u00021A\u0005\u0002M\nQb\u001d;beR$\u0016.\\3`I\u0015\fHC\u0001\u00135\u0011\u001dA\u0013'!AA\u00029BaAN\b!B\u0013q\u0013AC:uCJ$H+[7fA\u0019!\u0001C\u0001\u00019'\u00159\u0014(Q$K!\tQt(D\u0001<\u0015\taT(\u0001\u0003mC:<'\"\u0001 \u0002\t)\fg/Y\u0005\u0003\u0001n\u0012aa\u00142kK\u000e$\bC\u0001\"F\u001b\u0005\u0019%B\u0001#\u0007\u0003\u0011!\u0018m]6\n\u0005\u0019\u001b%AC*ue\u0016\fW\u000eV1tWB\u0011!\tS\u0005\u0003\u0013\u000e\u0013A\"\u00138ji\u0006\u0014G.\u001a+bg.\u0004\"a\u0013(\u000e\u00031S!!\u0014\u0004\u0002\tU$\u0018\u000e\\\u0005\u0003\u001f2\u0013q\u0001T8hO&tw\rC\u0003\u001ao\u0011\u0005\u0011\u000bF\u0001S!\tqq\u0007C\u0004Uo\u0001\u0007I\u0011A\u000f\u0002\u00171|w-\u00138uKJ4\u0018\r\u001c\u0005\b-^\u0002\r\u0011\"\u0001X\u0003=awnZ%oi\u0016\u0014h/\u00197`I\u0015\fHC\u0001\u0013Y\u0011\u001dAS+!AA\u0002yAaAW\u001c!B\u0013q\u0012\u0001\u00047pO&sG/\u001a:wC2\u0004\u0003b\u0002/8\u0001\u0004%\t!H\u0001\f[\u0006DX*Z:tC\u001e,7\u000fC\u0004_o\u0001\u0007I\u0011A0\u0002\u001f5\f\u00070T3tg\u0006<Wm]0%KF$\"\u0001\n1\t\u000f!j\u0016\u0011!a\u0001=!1!m\u000eQ!\ny\tA\"\\1y\u001b\u0016\u001c8/Y4fg\u0002Bq\u0001Z\u001cA\u0002\u0013\u0005Q-\u0001\npkR\u0004X\u000f^*zgR,Wn\u0015;sK\u0006lW#\u00014\u0011\u0007M9\u0017.\u0003\u0002i)\t1q\n\u001d;j_:\u0004\"A[7\u000e\u0003-T!\u0001\u001c\u0004\u0002\rML8\u000f^3n\u0013\tq7N\u0001\u0007TsN$X-\\*ue\u0016\fW\u000eC\u0004qo\u0001\u0007I\u0011A9\u0002-=,H\u000f];u'f\u001cH/Z7TiJ,\u0017-\\0%KF$\"\u0001\n:\t\u000f!z\u0017\u0011!a\u0001M\"1Ao\u000eQ!\n\u0019\f1c\\;uaV$8+_:uK6\u001cFO]3b[\u0002BQA^\u001c\u0005\u0002]\fA!\u001b8jiR\u0011A\u0005\u001f\u0005\u0006sV\u0004\rA_\u0001\bG>tG/\u001a=u!\tYX0D\u0001}\u0015\tIh!\u0003\u0002\u007fy\n91i\u001c8uKb$\bbBA\u0001o\u0011\u0005\u00111A\u0001\baJ|7-Z:t)\u001d!\u0013QAA\b\u00033Aq!a\u0002\u0000\u0001\u0004\tI!\u0001\u0005f]Z,Gn\u001c9f!\rQ\u00171B\u0005\u0004\u0003\u001bY'aF%oG>l\u0017N\\4NKN\u001c\u0018mZ3F]Z,Gn\u001c9f\u0011\u001d\t\tb a\u0001\u0003'\t\u0011bY8mY\u0016\u001cGo\u001c:\u0011\u0007\t\u000b)\"C\u0002\u0002\u0018\r\u0013\u0001#T3tg\u0006<WmQ8mY\u0016\u001cGo\u001c:\t\u000f\u0005mq\u00101\u0001\u0002\u001e\u0005Y1m\\8sI&t\u0017\r^8s!\r\u0011\u0015qD\u0005\u0004\u0003C\u0019%a\u0004+bg.\u001cun\u001c:eS:\fGo\u001c:")
public class TestPerformanceTask
implements StreamTask,
InitableTask,
Logging {
    private int logInterval;
    private int maxMessages;
    private Option<SystemStream> outputSystemStream;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public static void startTime_$eq(long l) {
        TestPerformanceTask$.MODULE$.startTime_$eq(l);
    }

    public static long startTime() {
        return TestPerformanceTask$.MODULE$.startTime();
    }

    public static void messagesProcessed_$eq(int n) {
        TestPerformanceTask$.MODULE$.messagesProcessed_$eq(n);
    }

    public static int messagesProcessed() {
        return TestPerformanceTask$.MODULE$.messagesProcessed();
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TestPerformanceTask testPerformanceTask = this;
        synchronized (testPerformanceTask) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        TestPerformanceTask testPerformanceTask = this;
        synchronized (testPerformanceTask) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging.class.startupLogger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    public void startupLog(Function0<Object> message) {
        Logging.class.startupLog((Logging)this, message);
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, message, e);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, message, e);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.info((Logging)this, message, e);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, message, e);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.error((Logging)this, message, e);
    }

    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging.class.putMDC((Logging)this, key, value);
    }

    public String getMDC(Function0<String> key) {
        return Logging.class.getMDC((Logging)this, key);
    }

    public void removeMDC(Function0<String> key) {
        Logging.class.removeMDC((Logging)this, key);
    }

    public void clearMDC() {
        Logging.class.clearMDC((Logging)this);
    }

    public int logInterval() {
        return this.logInterval;
    }

    public void logInterval_$eq(int x$1) {
        this.logInterval = x$1;
    }

    public int maxMessages() {
        return this.maxMessages;
    }

    public void maxMessages_$eq(int x$1) {
        this.maxMessages = x$1;
    }

    public Option<SystemStream> outputSystemStream() {
        return this.outputSystemStream;
    }

    public void outputSystemStream_$eq(Option<SystemStream> x$1) {
        this.outputSystemStream = x$1;
    }

    public void init(Context context) {
        Config config = context.getJobContext().getConfig();
        this.logInterval_$eq(config.getInt("task.log.interval", 10000));
        this.maxMessages_$eq(config.getInt("task.max.messages", 10000000));
        this.outputSystemStream_$eq((Option<SystemStream>)Option$.MODULE$.apply((Object)config.get("task.outputs", null)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SystemStream apply(String x$1) {
                return StreamUtil.getSystemStreamFromNames((String)x$1);
            }
        }));
    }

    public void process(IncomingMessageEnvelope envelope, MessageCollector collector, TaskCoordinator coordinator) {
        if (TestPerformanceTask$.MODULE$.startTime() == 0L) {
            TestPerformanceTask$.MODULE$.startTime_$eq(System.currentTimeMillis());
        }
        if (this.outputSystemStream().isDefined()) {
            collector.send(new OutgoingMessageEnvelope((SystemStream)this.outputSystemStream().get(), envelope.getKey(), envelope.getMessage()));
        }
        TestPerformanceTask$.MODULE$.messagesProcessed_$eq(TestPerformanceTask$.MODULE$.messagesProcessed() + 1);
        if (TestPerformanceTask$.MODULE$.messagesProcessed() % this.logInterval() == 0) {
            long seconds = (System.currentTimeMillis() - TestPerformanceTask$.MODULE$.startTime()) / 1000L;
            this.info((Function0<Object>)new Serializable(this, seconds){
                public static final long serialVersionUID = 0L;
                private final long seconds$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Processed %s messages in %s seconds.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)TestPerformanceTask$.MODULE$.messagesProcessed()), BoxesRunTime.boxToLong((long)this.seconds$1)}));
                }
                {
                    this.seconds$1 = seconds$1;
                }
            });
        }
        if (TestPerformanceTask$.MODULE$.messagesProcessed() >= this.maxMessages()) {
            coordinator.shutdown(TaskCoordinator.RequestScope.ALL_TASKS_IN_CONTAINER);
        }
    }

    public TestPerformanceTask() {
        Logging.class.$init$((Logging)this);
        this.logInterval = 10000;
        this.maxMessages = 10000000;
        this.outputSystemStream = None$.MODULE$;
    }
}

