/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.converter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.flink.connector.jdbc.internal.converter.JdbcRowConverter;
import org.apache.flink.connector.jdbc.statement.FieldNamedPreparedStatement;
import org.apache.flink.connector.jdbc.utils.JdbcTypeUtil;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;

public abstract class AbstractJdbcRowConverter
implements JdbcRowConverter {
    protected final RowType rowType;
    protected final JdbcDeserializationConverter[] toInternalConverters;
    protected final JdbcSerializationConverter[] toExternalConverters;
    protected final LogicalType[] fieldTypes;

    public abstract String converterName();

    public AbstractJdbcRowConverter(RowType rowType) {
        this.rowType = (RowType)Preconditions.checkNotNull((Object)rowType);
        this.fieldTypes = (LogicalType[])rowType.getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new);
        this.toInternalConverters = new JdbcDeserializationConverter[rowType.getFieldCount()];
        this.toExternalConverters = new JdbcSerializationConverter[rowType.getFieldCount()];
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            this.toInternalConverters[i] = this.createNullableInternalConverter(rowType.getTypeAt(i));
            this.toExternalConverters[i] = this.createNullableExternalConverter(this.fieldTypes[i]);
        }
    }

    @Override
    public RowData toInternal(ResultSet resultSet) throws SQLException {
        GenericRowData genericRowData = new GenericRowData(this.rowType.getFieldCount());
        for (int pos = 0; pos < this.rowType.getFieldCount(); ++pos) {
            Object field = resultSet.getObject(pos + 1);
            genericRowData.setField(pos, this.toInternalConverters[pos].deserialize(field));
        }
        return genericRowData;
    }

    @Override
    public FieldNamedPreparedStatement toExternal(RowData rowData, FieldNamedPreparedStatement statement) throws SQLException {
        for (int index = 0; index < rowData.getArity(); ++index) {
            this.toExternalConverters[index].serialize(rowData, index, statement);
        }
        return statement;
    }

    protected JdbcDeserializationConverter createNullableInternalConverter(LogicalType type) {
        return this.wrapIntoNullableInternalConverter(this.createInternalConverter(type));
    }

    protected JdbcDeserializationConverter wrapIntoNullableInternalConverter(JdbcDeserializationConverter jdbcDeserializationConverter) {
        return val -> {
            if (val == null) {
                return null;
            }
            return jdbcDeserializationConverter.deserialize(val);
        };
    }

    protected JdbcDeserializationConverter createInternalConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return val -> null;
            }
            case BOOLEAN: 
            case FLOAT: 
            case DOUBLE: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: {
                return val -> val;
            }
            case TINYINT: {
                return val -> ((Integer)val).byteValue();
            }
            case SMALLINT: {
                return val -> val instanceof Integer ? Short.valueOf(((Integer)val).shortValue()) : val;
            }
            case INTEGER: {
                return val -> val;
            }
            case BIGINT: {
                return val -> val;
            }
            case DECIMAL: {
                int precision = ((DecimalType)type).getPrecision();
                int scale = ((DecimalType)type).getScale();
                return val -> val instanceof BigInteger ? DecimalData.fromBigDecimal((BigDecimal)new BigDecimal((BigInteger)val, 0), (int)precision, (int)scale) : DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)val), (int)precision, (int)scale);
            }
            case DATE: {
                return val -> (int)((Date)val).toLocalDate().toEpochDay();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return val -> (int)(((Time)val).toLocalTime().toNanoOfDay() / 1000000L);
            }
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return val -> val instanceof LocalDateTime ? TimestampData.fromLocalDateTime((LocalDateTime)((LocalDateTime)val)) : TimestampData.fromTimestamp((Timestamp)((Timestamp)val));
            }
            case CHAR: 
            case VARCHAR: {
                return val -> StringData.fromString((String)((String)val));
            }
            case BINARY: 
            case VARBINARY: {
                return val -> (byte[])val;
            }
        }
        throw new UnsupportedOperationException("Unsupported type:" + type);
    }

    protected JdbcSerializationConverter createNullableExternalConverter(LogicalType type) {
        return this.wrapIntoNullableExternalConverter(this.createExternalConverter(type), type);
    }

    protected JdbcSerializationConverter wrapIntoNullableExternalConverter(JdbcSerializationConverter jdbcSerializationConverter, LogicalType type) {
        int sqlType = JdbcTypeUtil.typeInformationToSqlType(TypeConversions.fromDataTypeToLegacyInfo((DataType)TypeConversions.fromLogicalToDataType((LogicalType)type)));
        return (val, index, statement) -> {
            if (val == null || val.isNullAt(index) || LogicalTypeRoot.NULL.equals((Object)type.getTypeRoot())) {
                statement.setNull(index, sqlType);
            } else {
                jdbcSerializationConverter.serialize(val, index, statement);
            }
        };
    }

    protected JdbcSerializationConverter createExternalConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                return (val, index, statement) -> statement.setBoolean(index, val.getBoolean(index));
            }
            case TINYINT: {
                return (val, index, statement) -> statement.setByte(index, val.getByte(index));
            }
            case SMALLINT: {
                return (val, index, statement) -> statement.setShort(index, val.getShort(index));
            }
            case INTERVAL_YEAR_MONTH: 
            case INTEGER: {
                return (val, index, statement) -> statement.setInt(index, val.getInt(index));
            }
            case INTERVAL_DAY_TIME: 
            case BIGINT: {
                return (val, index, statement) -> statement.setLong(index, val.getLong(index));
            }
            case FLOAT: {
                return (val, index, statement) -> statement.setFloat(index, val.getFloat(index));
            }
            case DOUBLE: {
                return (val, index, statement) -> statement.setDouble(index, val.getDouble(index));
            }
            case CHAR: 
            case VARCHAR: {
                return (val, index, statement) -> statement.setString(index, val.getString(index).toString());
            }
            case BINARY: 
            case VARBINARY: {
                return (val, index, statement) -> statement.setBytes(index, val.getBinary(index));
            }
            case DATE: {
                return (val, index, statement) -> statement.setDate(index, Date.valueOf(LocalDate.ofEpochDay(val.getInt(index))));
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (val, index, statement) -> statement.setTime(index, Time.valueOf(LocalTime.ofNanoOfDay((long)val.getInt(index) * 1000000L)));
            }
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int timestampPrecision = ((TimestampType)type).getPrecision();
                return (val, index, statement) -> statement.setTimestamp(index, val.getTimestamp(index, timestampPrecision).toTimestamp());
            }
            case DECIMAL: {
                int decimalPrecision = ((DecimalType)type).getPrecision();
                int decimalScale = ((DecimalType)type).getScale();
                return (val, index, statement) -> statement.setBigDecimal(index, val.getDecimal(index, decimalPrecision, decimalScale).toBigDecimal());
            }
        }
        throw new UnsupportedOperationException("Unsupported type:" + type);
    }

    @FunctionalInterface
    static interface JdbcSerializationConverter
    extends Serializable {
        public void serialize(RowData var1, int var2, FieldNamedPreparedStatement var3) throws SQLException;
    }

    @FunctionalInterface
    static interface JdbcDeserializationConverter
    extends Serializable {
        public Object deserialize(Object var1) throws SQLException;
    }
}

