/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.xa;

import java.io.IOException;
import java.util.Objects;
import javax.transaction.xa.Xid;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.connector.jdbc.xa.CheckpointAndXid;
import org.apache.flink.connector.jdbc.xa.XidSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class CheckpointAndXidSerializer
extends TypeSerializer<CheckpointAndXid> {
    private static final long serialVersionUID = 1L;
    public static final TypeSerializerSnapshot<CheckpointAndXid> SNAPSHOT = new CheckpointAndXidSimpleTypeSerializerSnapshot();
    private final TypeSerializer<Xid> xidSerializer = new XidSerializer();

    public boolean isImmutableType() {
        return this.xidSerializer.isImmutableType();
    }

    public TypeSerializer<CheckpointAndXid> duplicate() {
        return this;
    }

    public CheckpointAndXid createInstance() {
        return CheckpointAndXid.createRestored(0L, 0, (Xid)this.xidSerializer.createInstance());
    }

    public CheckpointAndXid copy(CheckpointAndXid from) {
        return CheckpointAndXid.createRestored(from.checkpointId, from.attempts, (Xid)this.xidSerializer.copy((Object)from.xid));
    }

    public CheckpointAndXid copy(CheckpointAndXid from, CheckpointAndXid reuse) {
        return from;
    }

    public int getLength() {
        return -1;
    }

    public void serialize(CheckpointAndXid record, DataOutputView target) throws IOException {
        target.writeLong(record.checkpointId);
        target.writeInt(record.attempts);
        this.xidSerializer.serialize((Object)record.xid, target);
    }

    public CheckpointAndXid deserialize(DataInputView source) throws IOException {
        return CheckpointAndXid.createRestored(source.readLong(), source.readInt(), (Xid)this.xidSerializer.deserialize(source));
    }

    public CheckpointAndXid deserialize(CheckpointAndXid reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public boolean equals(Object o) {
        return o instanceof CheckpointAndXidSerializer;
    }

    public int hashCode() {
        return Objects.hash(this.xidSerializer);
    }

    public TypeSerializerSnapshot<CheckpointAndXid> snapshotConfiguration() {
        return SNAPSHOT;
    }

    public static class CheckpointAndXidSimpleTypeSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<CheckpointAndXid> {
        private static final int VERSION = 1;

        public CheckpointAndXidSimpleTypeSerializerSnapshot() {
            super(CheckpointAndXidSerializer::new);
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            super.writeSnapshot(out);
            out.writeInt(1);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader classLoader) throws IOException {
            super.readSnapshot(readVersion, in, classLoader);
            in.readInt();
        }
    }
}

