/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.enumerator.subscriber;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.slf4j.Logger;

class KafkaSubscriberUtils {
    private KafkaSubscriberUtils() {
    }

    static void updatePartitionChanges(String topic, Set<TopicPartition> newPartitions, Set<TopicPartition> removedPartitions, List<TopicPartitionInfo> partitionInfoList) {
        for (TopicPartitionInfo pi : partitionInfoList) {
            TopicPartition tp = new TopicPartition(topic, pi.partition());
            if (removedPartitions.remove(tp)) continue;
            newPartitions.add(tp);
        }
    }

    static Map<String, TopicDescription> getTopicMetadata(AdminClient adminClient) {
        try {
            Set<String> topicNames = adminClient.listTopics().names().get();
            return adminClient.describeTopics(topicNames).all().get();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get topic metadata.", e);
        }
    }

    static void maybeLog(Set<TopicPartition> newPartitions, Set<TopicPartition> removedPartitions, Logger logger) {
        if (!removedPartitions.isEmpty()) {
            logger.warn("The following partitions have been removed from the Kafka cluster. {}", (Object)removedPartitions);
        }
        if (!newPartitions.isEmpty()) {
            logger.info("The following partitions have been added to the Kafka cluster. {}", (Object)newPartitions);
        }
    }
}

