/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.enumerator.subscriber;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.connector.kafka.source.enumerator.subscriber.KafkaSubscriber;
import org.apache.flink.connector.kafka.source.enumerator.subscriber.KafkaSubscriberUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartitionSetSubscriber
implements KafkaSubscriber {
    private static final long serialVersionUID = 390970375272146036L;
    private static final Logger LOG = LoggerFactory.getLogger(PartitionSetSubscriber.class);
    private final Set<TopicPartition> partitions;

    PartitionSetSubscriber(Set<TopicPartition> partitions) {
        this.partitions = partitions;
    }

    @Override
    public KafkaSubscriber.PartitionChange getPartitionChanges(AdminClient adminClient, Set<TopicPartition> currentAssignment) {
        HashSet<TopicPartition> newPartitions = new HashSet<TopicPartition>();
        HashSet<TopicPartition> removedPartitions = new HashSet<TopicPartition>(currentAssignment);
        Map<String, TopicDescription> topicMetadata = KafkaSubscriberUtils.getTopicMetadata(adminClient);
        for (TopicPartition tp : this.partitions) {
            TopicDescription topicDescription = topicMetadata.get(tp.topic());
            if (topicDescription == null || topicDescription.partitions().size() <= tp.partition() || removedPartitions.remove(tp)) continue;
            newPartitions.add(tp);
        }
        KafkaSubscriberUtils.maybeLog(newPartitions, removedPartitions, LOG);
        return new KafkaSubscriber.PartitionChange(newPartitions, removedPartitions);
    }
}

