/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.SecurityConfig;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProviderCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityConfig.class);
    private static final Map<String, ResourceType> NAME_TO_RESOURCE_TYPES = new HashMap<String, ResourceType>(ResourceType.values().length);
    private static final Map<String, AclOperation> NAME_TO_OPERATIONS = new HashMap<String, AclOperation>(AclOperation.values().length);

    public static KafkaPrincipal parseKafkaPrincipal(String str) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("expected a string in format principalType:principalName but got " + str);
        }
        String[] split = str.split(":", 2);
        if (split.length != 2) {
            throw new IllegalArgumentException("expected a string in format principalType:principalName but got " + str);
        }
        return new KafkaPrincipal(split[0], split[1]);
    }

    public static void addConfiguredSecurityProviders(Map<String, ?> configs) {
        String securityProviderClassesStr = (String)configs.get("security.providers");
        if (securityProviderClassesStr == null || securityProviderClassesStr.equals("")) {
            return;
        }
        try {
            String[] securityProviderClasses = securityProviderClassesStr.replaceAll("\\s+", "").split(",");
            for (int index = 0; index < securityProviderClasses.length; ++index) {
                SecurityProviderCreator securityProviderCreator = (SecurityProviderCreator)Class.forName(securityProviderClasses[index]).newInstance();
                securityProviderCreator.configure(configs);
                Security.insertProviderAt(securityProviderCreator.getProvider(), index + 1);
            }
        }
        catch (ClassCastException e) {
            LOGGER.error("Creators provided through security.providers are expected to be sub-classes of SecurityProviderCreator");
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.error("Unrecognized security provider creator class", cnfe);
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.error("Unexpected implementation of security provider creator class", e);
        }
    }

    public static ResourceType resourceType(String name) {
        ResourceType resourceType = NAME_TO_RESOURCE_TYPES.get(name);
        return resourceType == null ? ResourceType.UNKNOWN : resourceType;
    }

    public static AclOperation operation(String name) {
        AclOperation operation = NAME_TO_OPERATIONS.get(name);
        return operation == null ? AclOperation.UNKNOWN : operation;
    }

    private static String toPascalCase(String name) {
        StringBuilder builder = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                builder.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            builder.append(Character.toLowerCase(c));
        }
        return builder.toString();
    }

    static {
        for (ResourceType resourceType : ResourceType.values()) {
            String resourceTypeName = SecurityUtils.toPascalCase(resourceType.name());
            NAME_TO_RESOURCE_TYPES.put(resourceTypeName, resourceType);
        }
        for (Enum enum_ : AclOperation.values()) {
            String operationName = SecurityUtils.toPascalCase(enum_.name());
            NAME_TO_OPERATIONS.put(operationName, (AclOperation)enum_);
        }
    }
}

