/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.solr.conf;

import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrAuthzConf
extends Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(SolrAuthzConf.class);
    public static final String AUTHZ_SITE_FILE = "sentry-site.xml";

    public SolrAuthzConf(URL solrAuthzSiteURL) {
        super(true);
        this.addResource(solrAuthzSiteURL);
    }

    public String get(String varName) {
        return this.get(varName, AuthzConfVars.getDefault(varName));
    }

    public static enum AuthzConfVars {
        AUTHZ_PROVIDER("sentry.provider", "org.apache.sentry.provider.common.HadoopGroupResourceAuthorizationProvider"),
        AUTHZ_PROVIDER_RESOURCE("sentry.solr.provider.resource", ""),
        AUTHZ_PROVIDER_BACKEND("sentry.solr.provider.backend", "org.apache.sentry.provider.file.SimpleFileProviderBackend"),
        AUTHZ_POLICY_ENGINE("sentry.solr.policy.engine", "org.apache.sentry.policy.search.SimpleSearchPolicyEngine");

        private final String varName;
        private final String defaultVal;

        private AuthzConfVars(String varName, String defaultVal) {
            this.varName = varName;
            this.defaultVal = defaultVal;
        }

        public String getVar() {
            return this.varName;
        }

        public String getDefault() {
            return this.defaultVal;
        }

        public static String getDefault(String varName) {
            for (AuthzConfVars oneVar : AuthzConfVars.values()) {
                if (!oneVar.getVar().equalsIgnoreCase(varName)) continue;
                return oneVar.getDefault();
            }
            return null;
        }
    }
}

