/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.model.search;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.sentry.core.common.BitFieldAction;
import org.apache.sentry.core.common.BitFieldActionFactory;

public class SearchActionFactory
extends BitFieldActionFactory {
    private static final SearchAction[] AllActions = SearchAction.values();
    private static final SearchAction[] OneBitActions = new SearchAction[]{SearchAction.UPDATE, SearchAction.QUERY};

    public List<? extends BitFieldAction> getActionsByCode(int actionCode) {
        ArrayList actions = Lists.newArrayList();
        for (SearchAction action : OneBitActions) {
            if ((action.code & actionCode) != action.code) continue;
            actions.add(new SearchBitFieldAction(action));
        }
        return actions;
    }

    public BitFieldAction getActionByName(String name) {
        BitFieldAction val = null;
        for (SearchAction action : AllActions) {
            if (!action.name.equalsIgnoreCase(name)) continue;
            return new SearchBitFieldAction(action);
        }
        return val;
    }

    public static class SearchBitFieldAction
    extends BitFieldAction {
        public SearchBitFieldAction(SearchAction action) {
            super(action.getName(), action.getCode());
        }
    }

    public static enum SearchAction {
        UPDATE("update", 1),
        QUERY("query", 2),
        ALL("*", 3);

        private String name;
        private int code;

        private SearchAction(String name, int code) {
            this.name = name;
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public int getCode() {
            return this.code;
        }
    }
}

