/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.common;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.exception.SentryConfigurationException;
import org.apache.sentry.policy.common.PolicyEngine;
import org.apache.sentry.policy.common.PrivilegeFactory;
import org.apache.sentry.provider.common.GroupMappingService;
import org.apache.sentry.provider.common.ResourceAuthorizationProvider;
import org.junit.Assert;
import org.junit.Test;

public class TestGetGroupMapping {
    @Test
    public void testResourceAuthorizationProvider() {
        final HashSet set = Sets.newHashSet((Object[])new String[]{"a", "b", "c"});
        GroupMappingService mappingService = new GroupMappingService(){

            public Set<String> getGroups(String user) {
                return set;
            }
        };
        PolicyEngine policyEngine = new PolicyEngine(){

            public PrivilegeFactory getPrivilegeFactory() {
                return null;
            }

            public ImmutableSet<String> getAllPrivileges(Set<String> groups, ActiveRoleSet roleSet) throws SentryConfigurationException {
                return this.getPrivileges(groups, roleSet, new Authorizable[0]);
            }

            public ImmutableSet<String> getPrivileges(Set<String> groups, ActiveRoleSet roleSet, Authorizable ... authorizableHierarchy) {
                return ImmutableSet.of();
            }

            public void validatePolicy(boolean strictValidation) throws SentryConfigurationException {
            }

            public ImmutableSet<String> getAllPrivileges(Set<String> groups, Set<String> users, ActiveRoleSet roleSet) throws SentryConfigurationException {
                return this.getPrivileges(groups, users, roleSet, new Authorizable[0]);
            }

            public ImmutableSet<String> getPrivileges(Set<String> groups, Set<String> users, ActiveRoleSet roleSet, Authorizable ... authorizableHierarchy) throws SentryConfigurationException {
                return ImmutableSet.of();
            }

            public void close() {
            }
        };
        TestResourceAuthorizationProvider authProvider = new TestResourceAuthorizationProvider(policyEngine, mappingService);
        Assert.assertSame((Object)authProvider.getGroupMapping(), (Object)mappingService);
    }

    private static class TestResourceAuthorizationProvider
    extends ResourceAuthorizationProvider {
        public TestResourceAuthorizationProvider(PolicyEngine policy, GroupMappingService groupService) {
            super(policy, groupService, null);
        }
    }
}

