/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.tests.e2e.kafka;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import kafka.server.KafkaServerStartable;
import org.apache.curator.test.TestingServer;
import org.apache.sentry.tests.e2e.kafka.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTestServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaTestServer.class);
    private int kafkaPort = -1;
    private TestingServer zkServer;
    private KafkaServerStartable kafkaServer = null;
    private File sentrySitePath = null;

    public KafkaTestServer(File sentrySitePath) throws Exception {
        this.sentrySitePath = sentrySitePath;
        this.createZkServer();
        this.kafkaPort = TestUtils.getFreePort();
        this.createKafkaServer();
    }

    public void start() throws Exception {
        this.kafkaServer.startup();
        LOGGER.info("Started Kafka broker.");
    }

    public void shutdown() {
        if (this.kafkaServer != null) {
            this.kafkaServer.shutdown();
            this.kafkaServer.awaitShutdown();
            LOGGER.info("Stopped Kafka server.");
        }
        if (this.zkServer != null) {
            try {
                this.zkServer.stop();
                LOGGER.info("Stopped ZK server.");
            }
            catch (IOException e) {
                LOGGER.error("Failed to shutdown ZK server.", (Throwable)e);
            }
        }
    }

    private Path getTempDirectory() {
        Path tempDirectory = null;
        try {
            tempDirectory = Files.createTempDirectory("kafka-sentry-", new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create temp dir for Kafka's log dir.");
            throw new RuntimeException(e);
        }
        return tempDirectory;
    }

    private void setupKafkaProps(Properties props) throws UnknownHostException {
        props.put("listeners", "SSL://" + InetAddress.getLocalHost().getHostAddress() + ":" + this.kafkaPort);
        props.put("log.dir", this.getTempDirectory().toAbsolutePath().toString());
        props.put("zookeeper.connect", this.zkServer.getConnectString());
        props.put("replica.socket.timeout.ms", "1500");
        props.put("controller.socket.timeout.ms", "1500");
        props.put("controlled.shutdown.enable", (Object)true);
        props.put("delete.topic.enable", (Object)false);
        props.put("controlled.shutdown.retry.backoff.ms", "100");
        props.put("port", (Object)this.kafkaPort);
        props.put("authorizer.class.name", "org.apache.sentry.kafka.authorizer.SentryKafkaAuthorizer");
        props.put("sentry.kafka.site.url", "file://" + this.sentrySitePath.getAbsolutePath());
        props.put("allow.everyone.if.no.acl.found", "true");
        props.put("ssl.keystore.location", KafkaTestServer.class.getResource("/test.keystore.jks").getPath());
        props.put("ssl.keystore.password", "test-ks-passwd");
        props.put("ssl.key.password", "test-key-passwd");
        props.put("ssl.truststore.location", KafkaTestServer.class.getResource("/test.truststore.jks").getPath());
        props.put("ssl.truststore.password", "test-ts-passwd");
        props.put("security.inter.broker.protocol", "SSL");
        props.put("ssl.client.auth", "required");
        props.put("super.users", "User:CN=superuser;User:CN=superuser1; User:CN=Superuser2 ");
    }

    private void createKafkaServer() throws UnknownHostException {
        Properties props = new Properties();
        this.setupKafkaProps(props);
        this.kafkaServer = KafkaServerStartable.fromProps((Properties)props);
    }

    private void createZkServer() throws Exception {
        try {
            this.zkServer = new TestingServer();
        }
        catch (Exception e) {
            LOGGER.error("Failed to create testing zookeeper server.");
            throw new RuntimeException(e);
        }
    }

    public String getBootstrapServers() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress() + ":" + this.kafkaPort;
    }
}

