/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.qps;

import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.qps.Config;
import org.apache.servicecomb.qps.QpsConst;
import org.apache.servicecomb.qps.QpsControllerManager;
import org.apache.servicecomb.qps.QpsStrategy;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class ConsumerQpsFlowControlHandler
implements Handler {
    private final QpsControllerManager qpsControllerMgr = new QpsControllerManager(false);

    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        if (!Config.INSTANCE.isConsumerEnabled()) {
            invocation.next(asyncResp);
            return;
        }
        QpsStrategy qpsStrategy = this.qpsControllerMgr.getOrCreate(invocation.getMicroserviceName(), invocation);
        if (qpsStrategy.isLimitNewRequest()) {
            CommonExceptionData errorData = new CommonExceptionData("consumer request rejected by qps flowcontrol");
            asyncResp.consumerFail((Throwable)new InvocationException(QpsConst.TOO_MANY_REQUESTS_STATUS, (Object)errorData));
            return;
        }
        invocation.next(asyncResp);
    }
}

