/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.config.inject.InjectProperties;
import org.apache.servicecomb.config.inject.InjectProperty;

@InjectProperties(prefix="servicecomb")
public class OperationConfig {
    public static final List<String> CONSUMER_OP_ANY_PRIORITY = Arrays.asList("${service}.${schema}.${operation}", "${service}.${schema}", "${service}");
    public static final List<String> PRODUCER_OP_ANY_PRIORITY = Arrays.asList("${schema}.${operation}", "${schema}");
    public static final List<String> CONSUMER_OP_PRIORITY = Arrays.asList(".${service}.${schema}.${operation}", ".${service}.${schema}", ".${service}", "");
    public static final List<String> PRODUCER_OP_PRIORITY = Arrays.asList(".${schema}.${operation}", ".${schema}", "");
    @InjectProperty(keys={"metrics.${consumer-producer}.invocation.slow.enabled${op-priority}", "${consumer-producer}.invocation.slow.enabled${op-priority}"}, defaultValue="false")
    private boolean slowInvocationEnabled;
    @InjectProperty(keys={"metrics.${consumer-producer}.invocation.slow.msTime${op-priority}", "${consumer-producer}.invocation.slow.msTime${op-priority}"}, defaultValue="1000")
    private long msSlowInvocation;
    private long nanoSlowInvocation;
    @InjectProperty(keys={"request.${op-any-priority}.timeout", "request.timeout"}, defaultValue="30000")
    private long msRequestTimeout;
    @InjectProperty(keys={"invocation.${op-any-priority}.timeout", "invocation.timeout"}, defaultValue="-1")
    private long msInvocationTimeout;
    private long nanoInvocationTimeout;
    @InjectProperty(keys={"request.clientRequestHeaderFilterEnabled${consumer-op-priority}"}, defaultValue="true")
    private boolean clientRequestHeaderFilterEnabled = true;
    private Map<String, Long> nanoRequestWaitInPoolTimeoutByTransport = new HashMap<String, Long>();
    @InjectProperty(keys={"Provider.requestWaitInPoolTimeout${op-priority}"}, defaultValue="30000")
    private long msDefaultRequestWaitInPoolTimeout;
    private long nanoDefaultRequestWaitInPoolTimeout;
    @InjectProperty(keys={"Provider.requestWaitInPoolTimeout${op-priority}", "highway.server.requestWaitInPoolTimeout"}, defaultValue="30000")
    private long msHighwayRequestWaitInPoolTimeout;
    private long nanoHighwayRequestWaitInPoolTimeout;
    @InjectProperty(keys={"Provider.requestWaitInPoolTimeout${op-priority}", "rest.server.requestWaitInPoolTimeout"}, defaultValue="30000")
    private long msRestRequestWaitInPoolTimeout;
    private long nanoRestRequestWaitInPoolTimeout;
    @InjectProperty(keys={"operation${op-priority}.transport", "references.transport${op-priority}"})
    private String transport;
    @InjectProperty(keys={"governance.${op-any-priority}.matchType", "governance.matchType"}, defaultValue="rest")
    private String governanceMatchType;

    public boolean isSlowInvocationEnabled() {
        return this.slowInvocationEnabled;
    }

    public void setSlowInvocationEnabled(boolean slowInvocationEnabled) {
        this.slowInvocationEnabled = slowInvocationEnabled;
    }

    public long getMsSlowInvocation() {
        return this.msSlowInvocation;
    }

    public void setMsSlowInvocation(long msSlowInvocation) {
        this.msSlowInvocation = msSlowInvocation;
        this.nanoSlowInvocation = TimeUnit.MILLISECONDS.toNanos(msSlowInvocation);
    }

    public long getNanoSlowInvocation() {
        return this.nanoSlowInvocation;
    }

    public long getMsRequestTimeout() {
        return this.msRequestTimeout;
    }

    public void setMsRequestTimeout(long msRequestTimeout) {
        this.msRequestTimeout = msRequestTimeout;
    }

    public long getNanoRequestWaitInPoolTimeout(String transport) {
        return this.nanoRequestWaitInPoolTimeoutByTransport.getOrDefault(transport, this.nanoDefaultRequestWaitInPoolTimeout);
    }

    public void registerRequestWaitInPoolTimeout(String transport, long msTimeout) {
        this.nanoRequestWaitInPoolTimeoutByTransport.put(transport, TimeUnit.MILLISECONDS.toNanos(msTimeout));
    }

    public long getMsDefaultRequestWaitInPoolTimeout() {
        return this.msDefaultRequestWaitInPoolTimeout;
    }

    public void setMsDefaultRequestWaitInPoolTimeout(long msDefaultRequestWaitInPoolTimeout) {
        this.msDefaultRequestWaitInPoolTimeout = msDefaultRequestWaitInPoolTimeout;
        this.nanoDefaultRequestWaitInPoolTimeout = TimeUnit.MILLISECONDS.toNanos(msDefaultRequestWaitInPoolTimeout);
    }

    public long getNanoDefaultRequestWaitInPoolTimeout() {
        return this.nanoDefaultRequestWaitInPoolTimeout;
    }

    public long getMsHighwayRequestWaitInPoolTimeout() {
        return this.msHighwayRequestWaitInPoolTimeout;
    }

    public void setMsHighwayRequestWaitInPoolTimeout(long msHighwayRequestWaitInPoolTimeout) {
        this.msHighwayRequestWaitInPoolTimeout = msHighwayRequestWaitInPoolTimeout;
        this.nanoHighwayRequestWaitInPoolTimeout = TimeUnit.MILLISECONDS.toNanos(msHighwayRequestWaitInPoolTimeout);
        this.registerRequestWaitInPoolTimeout("highway", msHighwayRequestWaitInPoolTimeout);
    }

    public long getNanoHighwayRequestWaitInPoolTimeout() {
        return this.nanoHighwayRequestWaitInPoolTimeout;
    }

    public long getMsRestRequestWaitInPoolTimeout() {
        return this.msRestRequestWaitInPoolTimeout;
    }

    public void setMsRestRequestWaitInPoolTimeout(long msRestRequestWaitInPoolTimeout) {
        this.msRestRequestWaitInPoolTimeout = msRestRequestWaitInPoolTimeout;
        this.nanoRestRequestWaitInPoolTimeout = TimeUnit.MILLISECONDS.toNanos(msRestRequestWaitInPoolTimeout);
        this.registerRequestWaitInPoolTimeout("rest", msRestRequestWaitInPoolTimeout);
    }

    public long getNanoRestRequestWaitInPoolTimeout() {
        return this.nanoRestRequestWaitInPoolTimeout;
    }

    public long getMsInvocationTimeout() {
        return this.msInvocationTimeout;
    }

    public void setMsInvocationTimeout(long msInvocationTimeout) {
        this.msInvocationTimeout = msInvocationTimeout;
        this.nanoInvocationTimeout = TimeUnit.MILLISECONDS.toNanos(msInvocationTimeout);
    }

    public String getGovernanceMatchType() {
        return this.governanceMatchType;
    }

    public void setGovernanceMatchType(String governanceMatchType) {
        this.governanceMatchType = governanceMatchType;
    }

    public long getNanoInvocationTimeout() {
        return this.nanoInvocationTimeout;
    }

    public boolean isClientRequestHeaderFilterEnabled() {
        return this.clientRequestHeaderFilterEnabled;
    }

    public void setClientRequestHeaderFilterEnabled(boolean clientRequestHeaderFilterEnabled) {
        this.clientRequestHeaderFilterEnabled = clientRequestHeaderFilterEnabled;
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        if (transport == null) {
            transport = "";
        }
        this.transport = transport;
    }
}

