/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.impl;

import com.netflix.config.DynamicPropertyFactory;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import javax.validation.groups.Default;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.ProducerFilter;
import org.apache.servicecomb.core.filter.impl.JacksonPropertyNodeNameProvider;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.apache.servicecomb.swagger.invocation.Response;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.messageinterpolation.AbstractMessageInterpolator;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.spi.nodenameprovider.PropertyNodeNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class ParameterValidatorFilter
implements ProducerFilter,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterValidatorFilter.class);
    public static final String NAME = "validator";
    private static final String ENABLE_EL = "servicecomb.filters.validation.useResourceBundleMessageInterpolator";
    protected ExecutableValidator validator;

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    public void afterPropertiesSet() {
        this.validator = this.createValidatorFactory().getValidator().forExecutables();
    }

    protected ValidatorFactory createValidatorFactory() {
        return ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).propertyNodeNameProvider((PropertyNodeNameProvider)new JacksonPropertyNodeNameProvider())).messageInterpolator((MessageInterpolator)this.messageInterpolator())).buildValidatorFactory();
    }

    protected AbstractMessageInterpolator messageInterpolator() {
        if (this.useResourceBundleMessageInterpolator()) {
            return new ResourceBundleMessageInterpolator();
        }
        return new ParameterMessageInterpolator();
    }

    private boolean useResourceBundleMessageInterpolator() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty(ENABLE_EL, false).get();
    }

    @Override
    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        Set<ConstraintViolation<Object>> violations = this.doValidate(invocation);
        if (violations.size() > 0) {
            LOGGER.error("Parameter validation failed : " + violations.toString());
            return AsyncUtils.completeExceptionally((Throwable)new ConstraintViolationException(violations));
        }
        return nextNode.onFilter(invocation);
    }

    protected Set<ConstraintViolation<Object>> doValidate(Invocation invocation) {
        SwaggerProducerOperation producerOperation = invocation.getOperationMeta().getSwaggerProducerOperation();
        Object instance = producerOperation.getProducerInstance();
        Method method = producerOperation.getProducerMethod();
        Object[] args = invocation.toProducerArguments();
        return this.validator.validateParameters(instance, method, args, new Class[]{Default.class});
    }
}

