/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.governance;

import com.netflix.config.DynamicPropertyFactory;

public class GovernanceConfiguration {
    public static final String ROOT = "servicecomb.loadbalance.";
    public static final String RETRY_ENABLED = "retryEnabled";
    public static final String RETRY_ON_NEXT = "retryOnNext";
    public static final String RETRY_ON_SAME = "retryOnSame";

    public static boolean isRetryEnabled(String microservice) {
        String p = GovernanceConfiguration.getStringProperty("false", ROOT + microservice + "." + RETRY_ENABLED, "servicecomb.loadbalance.retryEnabled");
        return Boolean.parseBoolean(p);
    }

    public static int getRetryNextServer(String microservice) {
        return GovernanceConfiguration.getRetryServer(microservice, RETRY_ON_NEXT);
    }

    public static int getRetrySameServer(String microservice) {
        return GovernanceConfiguration.getRetryServer(microservice, RETRY_ON_SAME);
    }

    private static int getRetryServer(String microservice, String retryType) {
        boolean defaultValue = false;
        String p = GovernanceConfiguration.getStringProperty("0", ROOT + microservice + "." + retryType, ROOT + retryType);
        try {
            int result = Integer.parseInt(p);
            if (result > 0) {
                return result;
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static String getStringProperty(String defaultValue, String ... keys) {
        for (String key : keys) {
            String property = DynamicPropertyFactory.getInstance().getStringProperty(key, null).get();
            if (property == null) continue;
            return property;
        }
        return defaultValue;
    }
}

