/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xmlbeans.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.DefaultValueWriter;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.wsdlto.core.DataBindingProfile;
import org.apache.cxf.xmlbeans.tools.XMLBeansSchemaTypeUtils;
import org.apache.xmlbeans.Filer;
import org.apache.xmlbeans.ResourceLoader;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.common.ResolverUtil;
import org.apache.xmlbeans.impl.common.XmlErrorWatcher;
import org.apache.xmlbeans.impl.config.BindingConfigImpl;
import org.apache.xmlbeans.impl.schema.PathResourceLoader;
import org.apache.xmlbeans.impl.schema.SchemaTypeLoaderImpl;
import org.apache.xmlbeans.impl.schema.SchemaTypeSystemCompiler;
import org.apache.xmlbeans.impl.schema.SchemaTypeSystemImpl;
import org.apache.xmlbeans.impl.schema.StscState;
import org.apache.xmlbeans.impl.tool.CodeGenUtil;
import org.apache.xmlbeans.impl.util.FilerImpl;
import org.apache.xmlbeans.impl.xb.substwsdl.DefinitionsDocument;
import org.apache.xmlbeans.impl.xb.substwsdl.TImport;
import org.apache.xmlbeans.impl.xb.xmlconfig.ConfigDocument;
import org.apache.xmlbeans.impl.xb.xmlconfig.Extensionconfig;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XMLBeansToolingDataBinding
implements DataBindingProfile {
    private static final String CONFIG_URI = "http://xml.apache.org/xmlbeans/2004/02/xbean/config";
    private static final String COMPATIBILITY_CONFIG_URI = "http://www.bea.com/2002/09/xbean/config";
    private static final Map<String, String> MAP_COMPATIBILITY_CONFIG_URIS = new HashMap<String, String>();
    SchemaTypeSystem typeSystem;
    SchemaTypeLoader typeLoader;
    Map<String, String> sourcesToCopyMap = new HashMap<String, String>();
    List<XmlError> errors = new LinkedList<XmlError>();
    XmlErrorWatcher errorListener = new XmlErrorWatcher(this.errors);
    PathResourceLoader cpResourceLoader = new PathResourceLoader(CodeGenUtil.systemClasspath());
    StscState state;

    public void initialize(ToolContext context) throws ToolException {
        context.put("databinding-class", (Object)"org.apache.cxf.xmlbeans.XmlBeansDataBinding.class");
        String wsdl = (String)context.get("wsdlurl");
        String catalog = (String)context.get("catalog");
        Object o = context.get("binding");
        String[] bindingFiles = o instanceof String ? new String[]{o.toString()} : (String[])o;
        this.state = StscState.start();
        this.state.setErrorListener((Collection)this.errorListener);
        EntityResolver cmdLineEntRes = ResolverUtil.resolverForCatalog((String)catalog);
        this.typeSystem = this.loadTypeSystem(wsdl, bindingFiles, null, null, null, cmdLineEntRes);
        StscState.end();
    }

    public DefaultValueWriter createDefaultValueWriter(QName qn, boolean element) {
        return null;
    }

    public DefaultValueWriter createDefaultValueWriterForWrappedElement(QName wrapperElement, QName qn) {
        return null;
    }

    public String getType(QName qn, boolean element) {
        if (element) {
            SchemaType type = this.typeSystem.findDocumentType(qn);
            if (type == null) {
                type = this.typeLoader.findDocumentType(qn);
            }
            if (type == null) {
                return null;
            }
            String ret = type.getFullJavaName();
            if (ret.contains("$")) {
                ret = ret.substring(0, ret.indexOf(36));
            }
            return ret;
        }
        SchemaType type = this.typeSystem.findType(qn);
        if (type == null) {
            type = this.typeLoader.findType(qn);
        }
        if (type == null && "http://www.w3.org/2001/XMLSchema".equals(qn.getNamespaceURI())) {
            return JAXBUtils.builtInTypeToJavaType((String)qn.getLocalPart());
        }
        if (type == null) {
            return null;
        }
        String ret = type.getFullJavaName();
        return ret.replace('$', '.');
    }

    public String getWrappedElementType(QName wrapperElement, QName item) {
        SchemaGlobalElement elem = this.typeSystem.findElement(wrapperElement);
        if (elem == null) {
            elem = this.typeLoader.findElement(wrapperElement);
        }
        SchemaType st = elem.getType();
        SchemaProperty prop = st.getElementProperty(item);
        SchemaType partType = prop.getType();
        String s = XMLBeansSchemaTypeUtils.getNaturalJavaClassName(partType);
        if (prop.extendsJavaArray()) {
            s = s + "[]";
        }
        return s;
    }

    public void generate(ToolContext context) throws ToolException {
        File classesDir;
        String srcd = (String)context.get("outputdir");
        String classesd = (String)context.get("classdir");
        boolean verbose = context.optionSet("verbose");
        boolean result = true;
        if (this.errorListener.hasError()) {
            result = false;
        }
        if (srcd == null) {
            String wsdl = (String)context.get("wsdlLocation");
            try {
                srcd = new File(new URI(wsdl)).getAbsolutePath();
            }
            catch (URISyntaxException e) {
                srcd = new File(".").getAbsolutePath();
            }
        }
        File srcDir = new File(srcd);
        srcDir.mkdirs();
        if (classesd == null) {
            classesDir = srcDir;
        } else {
            classesDir = new File(classesd);
            classesDir.mkdirs();
        }
        if (result) {
            final ClassCollector classCollector = (ClassCollector)context.get(ClassCollector.class);
            FilerImpl filer = new FilerImpl(classesDir, srcDir, null, verbose, false){

                public Writer createSourceFile(String typename) throws IOException {
                    String tn = typename;
                    if (tn.contains("$")) {
                        tn = tn.substring(0, tn.indexOf(36));
                    }
                    String pkg = tn.substring(0, tn.lastIndexOf(46));
                    tn = tn.substring(tn.lastIndexOf(46) + 1);
                    classCollector.addTypesClassName(pkg, tn, pkg + "." + tn);
                    return super.createSourceFile(typename);
                }
            };
            XmlOptions options = new XmlOptions();
            options.setGenerateJavaVersion("1.5");
            options.setCharacterEncoding((String)context.get("encoding"));
            this.typeSystem.save((Filer)filer);
            result &= SchemaTypeSystemCompiler.generateTypes((SchemaTypeSystem)this.typeSystem, (Filer)filer, (XmlOptions)options);
            for (Map.Entry<String, String> ent : this.sourcesToCopyMap.entrySet()) {
                try {
                    OutputStream out = filer.createBinaryFile("schema" + SchemaTypeSystemImpl.METADATA_PACKAGE_GEN + "/src/" + ent.getValue());
                    URL url = new URL(ent.getKey());
                    InputStream in = url.openStream();
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    out.close();
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        if (!result) {
            if (verbose) {
                System.out.println("BUILD FAILED");
            }
            StringBuilder sb = new StringBuilder("Error generating XMLBeans types\n");
            for (XmlError err : this.errors) {
                if (err.getSeverity() == 2) continue;
                sb.append(err.toString());
                if (err.getLine() != -1) {
                    sb.append(": ").append(err.getSourceName());
                    sb.append('[').append(Integer.toString(err.getLine())).append(',').append(Integer.toString(err.getColumn())).append(']');
                }
                sb.append('\n');
            }
            throw new ToolException(sb.toString());
        }
        if (this.cpResourceLoader != null) {
            this.cpResourceLoader.close();
        }
    }

    private SchemaTypeSystem loadTypeSystem(String wsdlFile, String[] configFiles, Set<?> mdefNamespaces, File baseDir, File schemasDir, EntityResolver entResolver) {
        SchemaTypeLoader loader = XmlBeans.typeLoaderForClassLoader((ClassLoader)SchemaDocument.class.getClassLoader());
        ArrayList<SchemaDocument.Schema> scontentlist = new ArrayList<SchemaDocument.Schema>();
        try {
            URL url = new URL(wsdlFile);
            XmlOptions options = new XmlOptions();
            options.setLoadLineNumbers();
            options.setLoadSubstituteNamespaces(Collections.singletonMap("http://schemas.xmlsoap.org/wsdl/", "http://www.apache.org/internal/xmlbeans/wsdlsubst"));
            options.setEntityResolver(entResolver);
            options.setGenerateJavaVersion("1.5");
            this.state.addSourceUri(wsdlFile, null);
            XMLBeansToolingDataBinding.loadWSDLDoc(loader, url, options, scontentlist, this.errorListener);
        }
        catch (XmlException e) {
            this.errorListener.add((Object)e.getError());
        }
        catch (Exception e) {
            StscState.addError((Collection)this.errorListener, (String)"cannot.load.file", (Object[])new Object[]{"url", wsdlFile, e.getMessage()}, (URL)null);
        }
        SchemaDocument.Schema[] sdocs = scontentlist.toArray(new SchemaDocument.Schema[scontentlist.size()]);
        ArrayList<ConfigDocument.Config> cdoclist = new ArrayList<ConfigDocument.Config>();
        ArrayList<File> javaFiles = new ArrayList<File>();
        if (configFiles != null) {
            for (int i = 0; i < configFiles.length; ++i) {
                if (configFiles[i].endsWith(".java")) {
                    javaFiles.add(new File(configFiles[i]));
                    continue;
                }
                if (!configFiles[i].endsWith(".xsdconfig")) continue;
                try {
                    XmlOptions options = new XmlOptions();
                    options.put((Object)"LOAD_LINE_NUMBERS");
                    options.setEntityResolver(entResolver);
                    options.setLoadSubstituteNamespaces(MAP_COMPATIBILITY_CONFIG_URIS);
                    URI uri = new URI(configFiles[i]);
                    XmlObject configdoc = null;
                    if ("file".equals(uri.getRawSchemeSpecificPart())) {
                        configdoc = loader.parse(new File(uri), null, options);
                    } else {
                        InputSource source = new InputSource(configFiles[i]);
                        Document doc = StaxUtils.read((InputSource)source);
                        configdoc = loader.parse((Node)doc, null, options);
                    }
                    if (!(configdoc instanceof ConfigDocument)) {
                        StscState.addError((Collection)this.errorListener, (String)"invalid.document.type", (Object[])new Object[]{configFiles[i], "xsd config"}, (XmlObject)configdoc);
                        continue;
                    }
                    StscState.addInfo((Collection)this.errorListener, (String)("Loading config file " + configFiles[i]));
                    if (!configdoc.validate(new XmlOptions().setErrorListener((Collection)this.errorListener))) continue;
                    ConfigDocument.Config config = ((ConfigDocument)configdoc).getConfig();
                    cdoclist.add(config);
                    config.setExtensionArray(new Extensionconfig[0]);
                    continue;
                }
                catch (XmlException e) {
                    this.errorListener.add((Object)e.getError());
                    continue;
                }
                catch (Exception e) {
                    StscState.addError((Collection)this.errorListener, (String)"cannot.load.file", (Object[])new Object[]{"xsd config", configFiles[i], e.getMessage()}, (File)new File(configFiles[i]));
                }
            }
        }
        ConfigDocument.Config[] cdocs = cdoclist.toArray(new ConfigDocument.Config[cdoclist.size()]);
        SchemaTypeLoader linkTo = SchemaTypeLoaderImpl.build(null, (ResourceLoader)this.cpResourceLoader, null);
        URI baseURI = null;
        if (baseDir != null) {
            baseURI = baseDir.toURI();
        }
        XmlOptions opts = new XmlOptions();
        opts.setCompileDownloadUrls();
        if (mdefNamespaces != null) {
            opts.setCompileMdefNamespaces(mdefNamespaces);
        }
        opts.setCompileNoValidation();
        opts.setEntityResolver(entResolver);
        opts.setGenerateJavaVersion("1.5");
        SchemaTypeSystemCompiler.Parameters params = new SchemaTypeSystemCompiler.Parameters();
        params.setSchemas(sdocs);
        params.setConfig(BindingConfigImpl.forConfigDocuments((ConfigDocument.Config[])cdocs, (File[])javaFiles.toArray(new File[javaFiles.size()]), (File[])CodeGenUtil.systemClasspath()));
        this.typeLoader = loader;
        params.setLinkTo(linkTo);
        params.setOptions(opts);
        params.setErrorListener((Collection)this.errorListener);
        params.setJavaize(true);
        params.setBaseURI(baseURI);
        params.setSourcesToCopyMap(this.sourcesToCopyMap);
        return SchemaTypeSystemCompiler.compile((SchemaTypeSystemCompiler.Parameters)params);
    }

    private static void loadWSDLDoc(SchemaTypeLoader loader, URL url, XmlOptions options, List<SchemaDocument.Schema> scontentlist, XmlErrorWatcher errorListener) throws XmlException, IOException {
        XmlObject urldoc = loader.parse(url, null, options);
        if (urldoc instanceof DefinitionsDocument) {
            DefinitionsDocument wsdldoc = (DefinitionsDocument)urldoc;
            XMLBeansToolingDataBinding.addWsdlSchemas(url.toString(), wsdldoc, errorListener, scontentlist);
            for (TImport imp : wsdldoc.getDefinitions().getImportArray()) {
                URL url1 = new URL(url, imp.getLocation());
                if (imp.getLocation().toLowerCase().endsWith(".xsd")) {
                    XmlObject urldoc2 = loader.parse(url1, null, options);
                    XMLBeansToolingDataBinding.addSchema(url1.toString(), (SchemaDocument)urldoc2, errorListener, false, scontentlist);
                    continue;
                }
                XMLBeansToolingDataBinding.loadWSDLDoc(loader, url1, options, scontentlist, errorListener);
            }
        } else if (urldoc instanceof SchemaDocument) {
            XMLBeansToolingDataBinding.addSchema(url.toString(), (SchemaDocument)urldoc, errorListener, false, scontentlist);
        } else {
            StscState.addError((Collection)errorListener, (String)"invalid.document.type", (Object[])new Object[]{url, "wsdl or schema"}, (XmlObject)urldoc);
        }
    }

    private static void addSchema(String name, SchemaDocument schemadoc, XmlErrorWatcher errorListener, boolean noVDoc, List<SchemaDocument.Schema> scontentlist) {
        StscState.addInfo((Collection)errorListener, (String)("Loading schema file " + name));
        XmlOptions opts = new XmlOptions().setErrorListener((Collection)errorListener);
        if (noVDoc) {
            opts.setValidateTreatLaxAsSkip();
        }
        if (schemadoc.validate(opts)) {
            scontentlist.add(schemadoc.getSchema());
        }
    }

    private static void addWsdlSchemas(String name, DefinitionsDocument wsdldoc, XmlErrorWatcher errorListener, List<SchemaDocument.Schema> scontentlist) {
        if (XMLBeansToolingDataBinding.wsdlContainsEncoded((XmlObject)wsdldoc)) {
            StscState.addWarning((Collection)errorListener, (String)("The WSDL " + name + " uses SOAP encoding. SOAP encoding " + "is not compatible with literal XML Schema."), (int)60, (XmlObject)wsdldoc);
        }
        StscState.addInfo((Collection)errorListener, (String)("Loading wsdl file " + name));
        XmlOptions opts = new XmlOptions().setErrorListener((Collection)errorListener);
        XmlObject[] types = wsdldoc.getDefinitions().getTypesArray();
        int count = 0;
        for (int j = 0; j < types.length; ++j) {
            XmlObject[] schemas = types[j].selectPath("declare namespace xs=\"http://www.w3.org/2001/XMLSchema\" xs:schema");
            if (schemas.length == 0) {
                StscState.addWarning((Collection)errorListener, (String)("The WSDL " + name + " did not have any schema documents in " + "namespace 'http://www.w3.org/2001/XMLSchema'"), (int)60, (XmlObject)wsdldoc);
                continue;
            }
            for (int k = 0; k < schemas.length; ++k) {
                if (!(schemas[k] instanceof SchemaDocument.Schema) || !schemas[k].validate(opts)) continue;
                ++count;
                scontentlist.add((SchemaDocument.Schema)schemas[k]);
            }
        }
        StscState.addInfo((Collection)errorListener, (String)("Processing " + count + " schema(s) in " + name));
    }

    private static boolean wsdlContainsEncoded(XmlObject wsdldoc) {
        XmlObject[] useAttrs = wsdldoc.selectPath("declare namespace soap='http://schemas.xmlsoap.org/wsdl/soap/' .//soap:body/@use|.//soap:header/@use|.//soap:fault/@use");
        for (int i = 0; i < useAttrs.length; ++i) {
            if (!"encoded".equals(((SimpleValue)useAttrs[i]).getStringValue())) continue;
            return true;
        }
        return false;
    }

    static {
        MAP_COMPATIBILITY_CONFIG_URIS.put(COMPATIBILITY_CONFIG_URI, CONFIG_URI);
    }
}

