/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.spring;

import java.util.Collections;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.spring.JaxRsConfig;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Import;

@Import(value={JaxRsConfig.class})
public abstract class AbstractSpringConfigurationFactory
extends AbstractBasicInterceptorProvider
implements ApplicationContextAware {
    protected ApplicationContext applicationContext;

    protected Server createJaxRsServer() {
        JAXRSServerFactoryBean factory = new JAXRSServerFactoryBean();
        factory.setAddress(this.getAddress());
        factory.setTransportId(this.getTransportId());
        factory.setBus((Bus)this.applicationContext.getBean(SpringBus.class));
        this.setJaxrsResources(factory);
        factory.setInInterceptors(this.getInInterceptors());
        factory.setOutInterceptors(this.getOutInterceptors());
        factory.setOutFaultInterceptors(this.getOutFaultInterceptors());
        factory.setFeatures(this.getFeatures());
        this.finalizeFactorySetup(factory);
        return factory.create();
    }

    public void setApplicationContext(ApplicationContext ac) throws BeansException {
        this.applicationContext = ac;
    }

    protected abstract void setJaxrsResources(JAXRSServerFactoryBean var1);

    protected List<Object> getJaxrsProviders() {
        return Collections.emptyList();
    }

    protected List<Feature> getFeatures() {
        return Collections.emptyList();
    }

    protected String getAddress() {
        return "/";
    }

    protected String getTransportId() {
        return "http://cxf.apache.org/transports/http";
    }

    protected void finalizeFactorySetup(JAXRSServerFactoryBean factory) {
    }
}

