/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.logger;

import java.io.PrintStream;
import org.apache.felix.http.base.internal.logger.AbstractLogger;
import org.osgi.framework.ServiceReference;

public final class ConsoleLogger
extends AbstractLogger {
    private final PrintStream out;

    public ConsoleLogger() {
        this(System.out);
    }

    public ConsoleLogger(PrintStream out) {
        this.out = out;
    }

    public void log(ServiceReference ref, int level, String message, Throwable cause) {
        StringBuffer str = new StringBuffer();
        switch (level) {
            case 4: {
                str.append("[DEBUG] ");
                break;
            }
            case 3: {
                str.append("[INFO] ");
                break;
            }
            case 2: {
                str.append("[WARNING] ");
                break;
            }
            case 1: {
                str.append("[ERROR] ");
            }
        }
        if (ref != null) {
            str.append("(").append(ref.toString()).append(") ");
        }
        str.append(message);
        this.out.println(str.toString());
        if (cause != null) {
            cause.printStackTrace(this.out);
        }
    }
}

